/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill.guard;

import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.neoevent.playerpatch.TakeDamageEvent;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.registry.entries.EpicFightParticles;
import yesman.epicfight.registry.entries.EpicFightSkillDataKeys;
import yesman.epicfight.registry.entries.EpicFightSkills;
import yesman.epicfight.registry.entries.EpicFightSounds;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.SkillEvent;
import yesman.epicfight.skill.guard.GuardSkill;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.WeaponCategory;

public class ParryingSkill
extends GuardSkill {
    private int parryWindow;

    public static GuardSkill.Builder createActiveGuardBuilder() {
        return GuardSkill.createGuardBuilder(ParryingSkill::new).addAdvancedGuardMotion(CapabilityItem.WeaponCategories.SWORD, (itemCap, playerpatch) -> itemCap.getStyle((LivingEntityPatch<?>)playerpatch) == CapabilityItem.Styles.ONE_HAND ? List.of(Animations.SWORD_GUARD_ACTIVE_HIT1, Animations.SWORD_GUARD_ACTIVE_HIT2) : List.of(Animations.SWORD_GUARD_ACTIVE_HIT2, Animations.SWORD_GUARD_ACTIVE_HIT3)).addAdvancedGuardMotion(CapabilityItem.WeaponCategories.LONGSWORD, (itemCap, playerpatch) -> List.of(Animations.LONGSWORD_GUARD_ACTIVE_HIT1, Animations.LONGSWORD_GUARD_ACTIVE_HIT2)).addAdvancedGuardMotion(CapabilityItem.WeaponCategories.UCHIGATANA, (itemCap, playerpatch) -> List.of(Animations.SWORD_GUARD_ACTIVE_HIT1, Animations.SWORD_GUARD_ACTIVE_HIT2)).addAdvancedGuardMotion(CapabilityItem.WeaponCategories.TACHI, (itemCap, playerpatch) -> List.of(Animations.LONGSWORD_GUARD_ACTIVE_HIT1, Animations.LONGSWORD_GUARD_ACTIVE_HIT2));
    }

    public ParryingSkill(GuardSkill.Builder builder) {
        super(builder);
    }

    @Override
    public void loadDatapackParameters(CompoundTag parameters) {
        super.loadDatapackParameters(parameters);
        this.parryWindow = parameters.getInt("parry_window");
        if (this.parryWindow <= 0) {
            this.parryWindow = 8;
        }
    }

    @Override
    public void startHolding(SkillContainer container) {
        super.startHolding(container);
        container.runOnServer(serverExecutor -> {
            int lastActive = container.getDataManager().getDataValue(EpicFightSkillDataKeys.LAST_ACTIVE);
            if (((ServerPlayer)serverExecutor.getOriginal()).tickCount - lastActive > this.parryWindow * 2) {
                container.getDataManager().setDataSync(EpicFightSkillDataKeys.LAST_ACTIVE, ((ServerPlayer)serverExecutor.getOriginal()).tickCount);
            }
        });
    }

    @SkillEvent(caller="epicfight", side=SkillEvent.Side.SERVER, override=true)
    public void serverRightClickItemEvent(PlayerInteractEvent.RightClickItem event, SkillContainer skillContainer) {
        int lastActive;
        CapabilityItem itemCapability = skillContainer.getExecutor().getHoldingItemCapability(InteractionHand.MAIN_HAND);
        if (this.isHoldingWeaponAvailable(skillContainer.getExecutor(), itemCapability, GuardSkill.BlockType.GUARD) && this.isExecutableState(skillContainer.getExecutor())) {
            ((Player)skillContainer.getExecutor().getOriginal()).startUsingItem(InteractionHand.MAIN_HAND);
        }
        if (((Player)skillContainer.getExecutor().getOriginal()).tickCount - (lastActive = skillContainer.getDataManager().getDataValue(EpicFightSkillDataKeys.LAST_ACTIVE).intValue()) > this.parryWindow * 2) {
            skillContainer.getDataManager().setData(EpicFightSkillDataKeys.LAST_ACTIVE, ((Player)skillContainer.getExecutor().getOriginal()).tickCount);
        }
    }

    @Override
    public void guard(SkillContainer container, CapabilityItem itemCapability, TakeDamageEvent.Income event, float knockback, float impact, boolean advanced) {
        DamageSource damageSource;
        Entity offender;
        if (this.isHoldingWeaponAvailable((PlayerPatch<?>)event.getPlayerPatch(), itemCapability, GuardSkill.BlockType.ADVANCED_GUARD) && (offender = ParryingSkill.getOffender(damageSource = event.getDamageSource())) != null && this.isBlockableSource(damageSource, true)) {
            ServerPlayer serverplayer = (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal();
            boolean successParrying = serverplayer.tickCount - container.getDataManager().getDataValue(EpicFightSkillDataKeys.LAST_ACTIVE) < this.parryWindow;
            float penalty = container.getDataManager().getDataValue(EpicFightSkillDataKeys.PENALTY).floatValue();
            ((ServerPlayerPatch)event.getPlayerPatch()).playSound((SoundEvent)EpicFightSounds.CLASH.get(), -0.05f, 0.1f);
            ((HitParticleType)((Object)EpicFightParticles.HIT_BLUNT.get())).spawnParticleWithArgument(serverplayer.serverLevel(), HitParticleType.FRONT_OF_EYES, HitParticleType.ZERO, (Entity)serverplayer, offender);
            if (successParrying) {
                event.setParried(true);
                penalty = 0.1f;
                knockback *= 0.4f;
                container.getDataManager().setData(EpicFightSkillDataKeys.LAST_ACTIVE, 0);
            } else {
                container.getDataManager().setDataSync(EpicFightSkillDataKeys.PENALTY, Float.valueOf(penalty += this.getPenalizer(itemCapability)));
            }
            if (offender instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)offender;
                float modifiedKnockback = EnchantmentHelper.modifyKnockback((ServerLevel)serverplayer.serverLevel(), (ItemStack)livingentity.getItemInHand(livingentity.getUsedItemHand()), (Entity)livingentity, (DamageSource)damageSource, (float)knockback);
                knockback = (modifiedKnockback - knockback) * 0.1f;
            }
            assert (offender != null);
            ((ServerPlayerPatch)event.getPlayerPatch()).knockBackEntity(offender.position(), knockback);
            float consumeAmount = penalty * impact;
            boolean canAfford = ((ServerPlayerPatch)event.getPlayerPatch()).consumeForSkill((Skill)this, Skill.Resource.STAMINA, consumeAmount);
            GuardSkill.BlockType blockType = successParrying ? GuardSkill.BlockType.ADVANCED_GUARD : (canAfford ? GuardSkill.BlockType.GUARD : GuardSkill.BlockType.GUARD_BREAK);
            AnimationManager.AnimationAccessor<? extends StaticAnimation> animation = this.getGuardMotion(container, (PlayerPatch<?>)event.getPlayerPatch(), itemCapability, blockType);
            if (animation != null) {
                ((ServerPlayerPatch)event.getPlayerPatch()).playAnimationSynchronized(animation, 0.0f);
            }
            if (blockType == GuardSkill.BlockType.GUARD_BREAK) {
                ((ServerPlayerPatch)event.getPlayerPatch()).playSound((SoundEvent)EpicFightSounds.NEUTRALIZE_MOBS.get(), 3.0f, 0.0f, 0.1f);
            }
            this.dealEvent((PlayerPatch<?>)event.getPlayerPatch(), event, advanced);
            return;
        }
        super.guard(container, itemCapability, event, knockback, impact, false);
    }

    @Override
    protected boolean isBlockableSource(DamageSource damageSource, boolean advanced) {
        return damageSource.is(DamageTypeTags.IS_PROJECTILE) && advanced || super.isBlockableSource(damageSource, false);
    }

    @Override
    @Nullable
    protected AnimationManager.AnimationAccessor<? extends StaticAnimation> getGuardMotion(SkillContainer container, PlayerPatch<?> playerpatch, CapabilityItem itemCapability, GuardSkill.BlockType blockType) {
        List motions;
        AnimationManager.AnimationAccessor<? extends StaticAnimation> animation = itemCapability.getGuardMotion(this, blockType, playerpatch);
        if (animation != null) {
            return animation;
        }
        if (blockType == GuardSkill.BlockType.ADVANCED_GUARD && (motions = (List)this.getGuardMotionMap(blockType).getOrDefault(itemCapability.getWeaponCategory(), (a, b) -> null).apply(itemCapability, playerpatch)) != null) {
            SkillDataManager dataManager = container.getDataManager();
            int motionCounter = dataManager.getDataValue(EpicFightSkillDataKeys.PARRY_MOTION_COUNTER);
            dataManager.setDataF(EpicFightSkillDataKeys.PARRY_MOTION_COUNTER, v -> v + 1);
            return (AnimationManager.AnimationAccessor)motions.get(motionCounter %= motions.size());
        }
        return super.getGuardMotion(container, playerpatch, itemCapability, blockType);
    }

    @Override
    public Skill getPriorSkill() {
        return (Skill)EpicFightSkills.GUARD.get();
    }

    @Override
    protected boolean isAdvancedGuard() {
        return true;
    }

    @Override
    public Set<WeaponCategory> getAvailableWeaponCategories() {
        return this.advancedGuardMotions.keySet();
    }
}

