/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.MobCombatBehaviors;
import yesman.epicfight.model.armature.HumanoidArmature;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPChangeLivingMotion;
import yesman.epicfight.registry.entries.EpicFightAttributes;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.Style;
import yesman.epicfight.world.capabilities.item.WeaponCategory;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.entity.ai.goal.AnimatedAttackGoal;
import yesman.epicfight.world.entity.ai.goal.CombatBehaviors;
import yesman.epicfight.world.entity.ai.goal.TargetChasingGoal;

public abstract class HumanoidMobPatch<T extends PathfinderMob>
extends MobPatch<T> {
    protected Map<WeaponCategory, Map<Style, Set<Pair<LivingMotion, AnimationManager.AnimationAccessor<? extends StaticAnimation>>>>> weaponLivingMotions;
    protected Map<WeaponCategory, Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>> weaponAttackMotions;

    public HumanoidMobPatch(T original, Faction faction) {
        super(original, faction);
        this.setWeaponMotions();
    }

    @Override
    public HumanoidArmature getArmature() {
        return (HumanoidArmature)this.armature;
    }

    @Override
    protected void initAI() {
        super.initAI();
        if (((PathfinderMob)this.original).getVehicle() != null && ((PathfinderMob)this.original).getVehicle() instanceof Mob) {
            this.setAIAsMounted(((PathfinderMob)this.original).getVehicle());
        } else {
            this.setAIAsInfantry(((PathfinderMob)this.original).getMainHandItem().getItem() instanceof ProjectileWeaponItem);
        }
    }

    @Override
    public void onStartTracking(ServerPlayer trackingPlayer) {
        this.modifyLivingMotionByCurrentItem(true);
    }

    protected void setWeaponMotions() {
        this.weaponLivingMotions = Maps.newHashMap();
        this.weaponLivingMotions.put(CapabilityItem.WeaponCategories.GREATSWORD, (Map<Style, Set<Pair<LivingMotion, AnimationManager.AnimationAccessor<? extends StaticAnimation>>>>)ImmutableMap.of((Object)CapabilityItem.Styles.TWO_HAND, Set.of(Pair.of((Object)LivingMotions.WALK, Animations.BIPED_WALK_TWOHAND), Pair.of((Object)LivingMotions.CHASE, Animations.BIPED_WALK_TWOHAND))));
        this.weaponAttackMotions = Maps.newHashMap();
        this.weaponAttackMotions.put(CapabilityItem.WeaponCategories.AXE, (Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>)ImmutableMap.of((Object)CapabilityItem.Styles.COMMON, MobCombatBehaviors.HUMANOID_ONEHAND_TOOLS));
        this.weaponAttackMotions.put(CapabilityItem.WeaponCategories.HOE, (Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>)ImmutableMap.of((Object)CapabilityItem.Styles.COMMON, MobCombatBehaviors.HUMANOID_ONEHAND_TOOLS));
        this.weaponAttackMotions.put(CapabilityItem.WeaponCategories.PICKAXE, (Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>)ImmutableMap.of((Object)CapabilityItem.Styles.COMMON, MobCombatBehaviors.HUMANOID_ONEHAND_TOOLS));
        this.weaponAttackMotions.put(CapabilityItem.WeaponCategories.SHOVEL, (Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>)ImmutableMap.of((Object)CapabilityItem.Styles.COMMON, MobCombatBehaviors.HUMANOID_ONEHAND_TOOLS));
        this.weaponAttackMotions.put(CapabilityItem.WeaponCategories.SWORD, (Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>)ImmutableMap.of((Object)CapabilityItem.Styles.ONE_HAND, MobCombatBehaviors.HUMANOID_ONEHAND_TOOLS, (Object)CapabilityItem.Styles.TWO_HAND, MobCombatBehaviors.HUMANOID_DUAL_SWORD));
        this.weaponAttackMotions.put(CapabilityItem.WeaponCategories.GREATSWORD, (Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>)ImmutableMap.of((Object)CapabilityItem.Styles.TWO_HAND, MobCombatBehaviors.HUMANOID_GREATSWORD));
        this.weaponAttackMotions.put(CapabilityItem.WeaponCategories.UCHIGATANA, (Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>)ImmutableMap.of((Object)CapabilityItem.Styles.TWO_HAND, MobCombatBehaviors.HUMANOID_KATANA));
        this.weaponAttackMotions.put(CapabilityItem.WeaponCategories.LONGSWORD, (Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>)ImmutableMap.of((Object)CapabilityItem.Styles.TWO_HAND, MobCombatBehaviors.HUMANOID_LONGSWORD));
        this.weaponAttackMotions.put(CapabilityItem.WeaponCategories.TACHI, (Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>)ImmutableMap.of((Object)CapabilityItem.Styles.TWO_HAND, MobCombatBehaviors.HUMANOID_TACHI));
        this.weaponAttackMotions.put(CapabilityItem.WeaponCategories.SPEAR, (Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>)ImmutableMap.of((Object)CapabilityItem.Styles.ONE_HAND, MobCombatBehaviors.HUMANOID_SPEAR_ONEHAND, (Object)CapabilityItem.Styles.TWO_HAND, MobCombatBehaviors.HUMANOID_SPEAR_TWOHAND));
        this.weaponAttackMotions.put(CapabilityItem.WeaponCategories.FIST, (Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>)ImmutableMap.of((Object)CapabilityItem.Styles.COMMON, MobCombatBehaviors.HUMANOID_FIST));
        this.weaponAttackMotions.put(CapabilityItem.WeaponCategories.DAGGER, (Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>)ImmutableMap.of((Object)CapabilityItem.Styles.ONE_HAND, MobCombatBehaviors.HUMANOID_ONEHAND_DAGGER, (Object)CapabilityItem.Styles.TWO_HAND, MobCombatBehaviors.HUMANOID_TWOHAND_DAGGER));
        this.weaponAttackMotions.put(CapabilityItem.WeaponCategories.RANGED, (Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>)ImmutableMap.of((Object)CapabilityItem.Styles.COMMON, MobCombatBehaviors.HUMANOID_FIST));
        this.weaponAttackMotions.put(CapabilityItem.WeaponCategories.TRIDENT, (Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>)ImmutableMap.of((Object)CapabilityItem.Styles.COMMON, MobCombatBehaviors.HUMANOID_SPEAR_ONEHAND));
    }

    protected CombatBehaviors.Builder<HumanoidMobPatch<?>> getHoldingItemWeaponMotionBuilder() {
        Style style;
        Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>> motionByStyle;
        CapabilityItem itemCap = this.getHoldingItemCapability(InteractionHand.MAIN_HAND);
        if (this.weaponAttackMotions.containsKey(itemCap.getWeaponCategory()) && ((motionByStyle = this.weaponAttackMotions.get(itemCap.getWeaponCategory())).containsKey(style = itemCap.getStyle(this)) || motionByStyle.containsKey(CapabilityItem.Styles.COMMON))) {
            return motionByStyle.getOrDefault(style, motionByStyle.get(CapabilityItem.Styles.COMMON));
        }
        return ((PathfinderMob)this.original).getMainHandItem().isEmpty() ? MobCombatBehaviors.HUMANOID_FIST : MobCombatBehaviors.HUMANOID_ONEHAND_TOOLS;
    }

    public void setAIAsInfantry(boolean holdingRanedWeapon) {
        CombatBehaviors.Builder<HumanoidMobPatch<?>> builder = this.getHoldingItemWeaponMotionBuilder();
        if (builder != null) {
            ((PathfinderMob)this.original).goalSelector.addGoal(0, new AnimatedAttackGoal<HumanoidMobPatch>(this, builder.build(this)));
            ((PathfinderMob)this.original).goalSelector.addGoal(1, (Goal)new TargetChasingGoal(this, (PathfinderMob)this.getOriginal(), 1.0, true));
        }
    }

    public void setAIAsMounted(Entity ridingEntity) {
        if (this.isArmed() && ridingEntity instanceof AbstractHorse) {
            ((PathfinderMob)this.original).goalSelector.addGoal(0, new AnimatedAttackGoal<HumanoidMobPatch>(this, MobCombatBehaviors.MOUNT_HUMANOID_BEHAVIORS.build(this)));
            ((PathfinderMob)this.original).goalSelector.addGoal(1, (Goal)new TargetChasingGoal(this, (PathfinderMob)this.getOriginal(), 1.0, true));
        }
    }

    protected final void commonMobAnimatorInit(Animator animator) {
        animator.addLivingAnimation(LivingMotions.IDLE, Animations.BIPED_IDLE);
        animator.addLivingAnimation(LivingMotions.WALK, Animations.BIPED_WALK);
        animator.addLivingAnimation(LivingMotions.FALL, Animations.BIPED_FALL);
        animator.addLivingAnimation(LivingMotions.MOUNT, Animations.BIPED_MOUNT);
        animator.addLivingAnimation(LivingMotions.DEATH, Animations.BIPED_DEATH);
    }

    protected final void commonAggresiveMobAnimatorInit(Animator animator) {
        animator.addLivingAnimation(LivingMotions.IDLE, Animations.BIPED_IDLE);
        animator.addLivingAnimation(LivingMotions.WALK, Animations.BIPED_WALK);
        animator.addLivingAnimation(LivingMotions.CHASE, Animations.BIPED_WALK);
        animator.addLivingAnimation(LivingMotions.FALL, Animations.BIPED_FALL);
        animator.addLivingAnimation(LivingMotions.MOUNT, Animations.BIPED_MOUNT);
        animator.addLivingAnimation(LivingMotions.DEATH, Animations.BIPED_DEATH);
    }

    @Override
    public void updateHeldItem(CapabilityItem fromCap, CapabilityItem toCap, ItemStack from, ItemStack to, InteractionHand hand) {
        this.initAI();
        if (hand == InteractionHand.OFF_HAND) {
            if (!from.isEmpty()) {
                to.getAttributeModifiers().forEach(EquipmentSlot.MAINHAND, (attribute, modifier) -> {
                    if (attribute == Attributes.ATTACK_SPEED) {
                        ((PathfinderMob)this.original).getAttribute(EpicFightAttributes.OFFHAND_ATTACK_SPEED).removeModifier(modifier);
                    }
                });
            }
            if (!fromCap.isEmpty()) {
                fromCap.getAttributeModifiers(this).get((Object)Attributes.ATTACK_SPEED).forEach(arg_0 -> ((AttributeInstance)((PathfinderMob)this.original).getAttribute(EpicFightAttributes.OFFHAND_ATTACK_SPEED)).removeModifier(arg_0));
                fromCap.getAttributeModifiers(this).get(EpicFightAttributes.ARMOR_NEGATION).forEach(arg_0 -> ((AttributeInstance)((PathfinderMob)this.original).getAttribute(EpicFightAttributes.OFFHAND_ARMOR_NEGATION)).removeModifier(arg_0));
                fromCap.getAttributeModifiers(this).get(EpicFightAttributes.IMPACT).forEach(arg_0 -> ((AttributeInstance)((PathfinderMob)this.original).getAttribute(EpicFightAttributes.OFFHAND_IMPACT)).removeModifier(arg_0));
                fromCap.getAttributeModifiers(this).get(EpicFightAttributes.MAX_STRIKES).forEach(arg_0 -> ((AttributeInstance)((PathfinderMob)this.original).getAttribute(EpicFightAttributes.OFFHAND_MAX_STRIKES)).removeModifier(arg_0));
            }
            if (!to.isEmpty()) {
                to.getAttributeModifiers().forEach(EquipmentSlot.MAINHAND, (attribute, modifier) -> {
                    if (attribute == Attributes.ATTACK_SPEED) {
                        ((PathfinderMob)this.original).getAttribute(EpicFightAttributes.OFFHAND_ATTACK_SPEED).addTransientModifier(modifier);
                    }
                });
            }
            if (!toCap.isEmpty()) {
                toCap.getAttributeModifiers(this).get((Object)Attributes.ATTACK_SPEED).forEach(arg_0 -> ((AttributeInstance)((PathfinderMob)this.original).getAttribute(EpicFightAttributes.OFFHAND_ARMOR_NEGATION)).addTransientModifier(arg_0));
                toCap.getAttributeModifiers(this).get(EpicFightAttributes.ARMOR_NEGATION).forEach(arg_0 -> ((AttributeInstance)((PathfinderMob)this.original).getAttribute(EpicFightAttributes.OFFHAND_ARMOR_NEGATION)).addTransientModifier(arg_0));
                toCap.getAttributeModifiers(this).get(EpicFightAttributes.IMPACT).forEach(arg_0 -> ((AttributeInstance)((PathfinderMob)this.original).getAttribute(EpicFightAttributes.OFFHAND_IMPACT)).addTransientModifier(arg_0));
                toCap.getAttributeModifiers(this).get(EpicFightAttributes.MAX_STRIKES).forEach(arg_0 -> ((AttributeInstance)((PathfinderMob)this.original).getAttribute(EpicFightAttributes.OFFHAND_MAX_STRIKES)).addTransientModifier(arg_0));
            }
        }
        this.modifyLivingMotionByCurrentItem(false);
        super.updateHeldItem(fromCap, toCap, from, to, hand);
    }

    public void modifyLivingMotionByCurrentItem(boolean onStartTracking) {
        Style style;
        Object byStyle;
        Map<LivingMotion, AssetAccessor<? extends StaticAnimation>> oldLivingAnimations = ((Animator)this.getAnimator()).getLivingAnimations();
        HashMap newLivingAnimations = Maps.newHashMap();
        CapabilityItem mainhandCap = this.getHoldingItemCapability(InteractionHand.MAIN_HAND);
        CapabilityItem offhandCap = this.getAdvancedHoldingItemCapability(InteractionHand.OFF_HAND);
        HashMap<LivingMotion, AnimationManager.AnimationAccessor<? extends StaticAnimation>> livingMotionModifiers = new HashMap<LivingMotion, AnimationManager.AnimationAccessor<? extends StaticAnimation>>(mainhandCap.getLivingMotionModifier(this, InteractionHand.MAIN_HAND));
        livingMotionModifiers.putAll(offhandCap.getLivingMotionModifier(this, InteractionHand.OFF_HAND));
        boolean hasChange = false;
        for (Map.Entry entry : livingMotionModifiers.entrySet()) {
            AssetAccessor aniamtion = (AssetAccessor)entry.getValue();
            if (!oldLivingAnimations.containsKey(entry.getKey())) {
                hasChange = true;
            } else if (oldLivingAnimations.get(entry.getKey()) != aniamtion) {
                hasChange = true;
            }
            newLivingAnimations.put((LivingMotion)entry.getKey(), aniamtion);
        }
        if (this.weaponLivingMotions != null && this.weaponLivingMotions.containsKey(mainhandCap.getWeaponCategory()) && ((byStyle = this.weaponLivingMotions.get(mainhandCap.getWeaponCategory())).containsKey(style = mainhandCap.getStyle(this)) || byStyle.containsKey(CapabilityItem.Styles.COMMON))) {
            Set animModifierSet = byStyle.getOrDefault(style, (Set)byStyle.get(CapabilityItem.Styles.COMMON));
            for (Pair pair : animModifierSet) {
                newLivingAnimations.put((LivingMotion)pair.getFirst(), (AssetAccessor)pair.getSecond());
            }
        }
        if (!hasChange) {
            for (LivingMotion oldLivingMotion : oldLivingAnimations.keySet()) {
                if (newLivingAnimations.containsKey(oldLivingMotion)) continue;
                hasChange = true;
                break;
            }
        }
        if (hasChange || onStartTracking) {
            ((Animator)this.getAnimator()).resetLivingAnimations();
            newLivingAnimations.forEach((arg_0, arg_1) -> this.getAnimator().addLivingAnimation(arg_0, arg_1));
            SPChangeLivingMotion msg = new SPChangeLivingMotion(((PathfinderMob)this.original).getId());
            msg.putEntries(newLivingAnimations.entrySet());
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(msg, this.original, new CustomPacketPayload[0]);
        }
    }

    public boolean isArmed() {
        Item heldItem = ((PathfinderMob)this.original).getMainHandItem().getItem();
        return heldItem instanceof SwordItem || heldItem instanceof DiggerItem || heldItem instanceof TridentItem;
    }

    @Override
    public void onMount(boolean isMountOrDismount, Entity ridingEntity) {
        if (this.original == null) {
            return;
        }
        if (!((PathfinderMob)this.original).level().isClientSide() && !((PathfinderMob)this.original).isNoAi()) {
            HashSet toRemove = Sets.newHashSet();
            this.selectGoalToRemove(toRemove);
            toRemove.forEach(arg_0 -> ((GoalSelector)((PathfinderMob)this.original).goalSelector).removeGoal(arg_0));
            if (isMountOrDismount) {
                this.setAIAsMounted(ridingEntity);
            } else {
                this.setAIAsInfantry(((PathfinderMob)this.original).getMainHandItem().getItem() instanceof ProjectileWeaponItem);
            }
        }
    }

    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getHitAnimation(StunType stunType) {
        if (((PathfinderMob)this.original).getVehicle() != null) {
            return Animations.BIPED_HIT_ON_MOUNT;
        }
        switch (stunType) {
            case LONG: {
                return Animations.BIPED_HIT_LONG;
            }
            case SHORT: {
                return Animations.BIPED_HIT_SHORT;
            }
            case HOLD: {
                return Animations.BIPED_HIT_SHORT;
            }
            case KNOCKDOWN: {
                return Animations.BIPED_KNOCKDOWN;
            }
            case NEUTRALIZE: {
                return Animations.BIPED_COMMON_NEUTRALIZED;
            }
            case FALL: {
                return Animations.BIPED_LANDING;
            }
            case NONE: {
                return null;
            }
        }
        return null;
    }
}

