/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch.mob;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.Set;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.MobCombatBehaviors;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.Factions;
import yesman.epicfight.world.capabilities.entitypatch.HumanoidMobPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.ai.goal.AnimatedAttackGoal;
import yesman.epicfight.world.entity.ai.goal.CombatBehaviors;
import yesman.epicfight.world.entity.ai.goal.TargetChasingGoal;

public class SkeletonPatch<T extends PathfinderMob>
extends HumanoidMobPatch<T> {
    public SkeletonPatch(T original) {
        super(original, Factions.UNDEAD);
    }

    public SkeletonPatch(T original, Faction faction) {
        super(original, faction);
    }

    @Override
    public void initAnimator(Animator animator) {
        super.initAnimator(animator);
        super.commonAggresiveMobAnimatorInit(animator);
    }

    @Override
    public void updateMotion(boolean considerInaction) {
        super.commonAggressiveRangedMobUpdateMotion(considerInaction);
    }

    @Override
    protected void setWeaponMotions() {
        super.setWeaponMotions();
        this.weaponLivingMotions.put(CapabilityItem.WeaponCategories.SWORD, ImmutableMap.of((Object)CapabilityItem.Styles.ONE_HAND, Set.of(Pair.of((Object)LivingMotions.CHASE, Animations.WITHER_SKELETON_CHASE))));
        this.weaponAttackMotions.put(CapabilityItem.WeaponCategories.SWORD, ImmutableMap.of((Object)CapabilityItem.Styles.COMMON, MobCombatBehaviors.SKELETON_SWORD));
    }

    @Override
    public void setAIAsInfantry(boolean holdingRanedWeapon) {
        CombatBehaviors.Builder<HumanoidMobPatch<?>> builder;
        if (!holdingRanedWeapon && (builder = this.getHoldingItemWeaponMotionBuilder()) != null) {
            ((PathfinderMob)this.original).goalSelector.addGoal(0, new AnimatedAttackGoal<SkeletonPatch>(this, builder.build(this)));
            ((PathfinderMob)this.original).goalSelector.addGoal(1, (Goal)new TargetChasingGoal(this, (PathfinderMob)this.original, 1.2, true));
        }
    }
}

