/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch.mob;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.Set;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.neoforged.neoforge.event.entity.EntityAttributeModificationEvent;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.MobCombatBehaviors;
import yesman.epicfight.registry.entries.EpicFightAttributes;
import yesman.epicfight.world.capabilities.entitypatch.Factions;
import yesman.epicfight.world.capabilities.entitypatch.mob.AbstractIllagerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;

public class VindicatorPatch<T extends PathfinderMob>
extends AbstractIllagerPatch<T> {
    public VindicatorPatch(T original) {
        super(original, Factions.ILLAGER);
    }

    @Override
    public void initAnimator(Animator animator) {
        super.initAnimator(animator);
        animator.addLivingAnimation(LivingMotions.ANGRY, Animations.VINDICATOR_IDLE_AGGRESSIVE);
        animator.addLivingAnimation(LivingMotions.CHASE, Animations.VINDICATOR_CHASE);
    }

    public static void initAttributes(EntityAttributeModificationEvent event) {
        event.add(EntityType.VINDICATOR, EpicFightAttributes.IMPACT, 1.0);
    }

    @Override
    protected void setWeaponMotions() {
        super.setWeaponMotions();
        this.weaponLivingMotions.put(CapabilityItem.WeaponCategories.GREATSWORD, ImmutableMap.of((Object)CapabilityItem.Styles.TWO_HAND, Set.of(Pair.of((Object)LivingMotions.WALK, Animations.ILLAGER_WALK), Pair.of((Object)LivingMotions.CHASE, Animations.BIPED_WALK_TWOHAND))));
        this.weaponAttackMotions.put(CapabilityItem.WeaponCategories.AXE, ImmutableMap.of((Object)CapabilityItem.Styles.COMMON, MobCombatBehaviors.VINDICATOR_ONEHAND));
        this.weaponAttackMotions.put(CapabilityItem.WeaponCategories.SWORD, ImmutableMap.of((Object)CapabilityItem.Styles.COMMON, MobCombatBehaviors.VINDICATOR_ONEHAND));
    }

    @Override
    public void updateMotion(boolean considerInaction) {
        if (((PathfinderMob)this.original).getHealth() <= 0.0f) {
            this.currentLivingMotion = LivingMotions.DEATH;
        } else if (this.state.inaction() && considerInaction) {
            this.currentLivingMotion = LivingMotions.INACTION;
        } else {
            boolean isAngry = ((PathfinderMob)this.original).isAggressive();
            this.currentLivingMotion = ((PathfinderMob)this.original).walkAnimation.speed() > 0.01f ? (isAngry ? LivingMotions.CHASE : LivingMotions.WALK) : (isAngry ? LivingMotions.ANGRY : LivingMotions.IDLE);
        }
    }

    @Override
    public void setAIAsMounted(Entity ridingEntity) {
    }
}

