/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.entity;

import java.util.List;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.registry.entries.EpicFightEntityTypes;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.EpicFightDamageSources;
import yesman.epicfight.world.damagesource.StunType;

public class AreaEffectBreath
extends AreaEffectCloud {
    private static final EntityDataAccessor<Boolean> DATA_HORIZONTAL = SynchedEntityData.defineId(AreaEffectBreath.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private Vec3 initialFirePosition;

    public AreaEffectBreath(EntityType<? extends AreaEffectBreath> entityType, Level level) {
        super(entityType, level);
        this.setDuration(5);
        this.addEffect(new MobEffectInstance(MobEffects.HARM, 1, 1));
    }

    public AreaEffectBreath(Level level, double x, double y, double z) {
        this((EntityType<? extends AreaEffectBreath>)((EntityType)EpicFightEntityTypes.AREA_EFFECT_BREATH.get()), level);
        this.setPos(x, y, z);
        this.initialFirePosition = new Vec3(x, y, z);
    }

    public void tick() {
        this.move(MoverType.SELF, this.getDeltaMovement());
        if (!this.level().isClientSide()) {
            if (this.tickCount >= this.getDuration()) {
                this.discard();
                return;
            }
            float f = this.getRadius();
            float radiusPerTick = this.getRadiusPerTick();
            if (radiusPerTick != 0.0f) {
                if ((f += radiusPerTick) < 0.5f) {
                    this.discard();
                    return;
                }
                this.setRadius(f);
            }
            this.victims.entrySet().removeIf(p_146784_ -> this.tickCount >= (Integer)p_146784_.getValue());
            List list1 = this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox());
            if (!list1.isEmpty()) {
                for (LivingEntity livingentity : list1) {
                    double d1;
                    double d8;
                    double d3;
                    EpicFightDamageSource damageSource;
                    if (livingentity.is((Entity)this.getOwner()) || livingentity.isInvulnerableTo((DamageSource)(damageSource = EpicFightDamageSources.enderDragonBreath(this.getOwner(), (Entity)this).setStunType(StunType.SHORT))) || this.victims.containsKey(livingentity) || !livingentity.isAffectedByPotions() || !((d3 = (d8 = livingentity.getX() - this.getX()) * d8 + (d1 = livingentity.getZ() - this.getZ()) * d1) <= (double)(f * f))) continue;
                    this.victims.put(livingentity, this.tickCount + 3);
                    livingentity.invulnerableTime = 0;
                    damageSource.setInitialPosition(this.initialFirePosition);
                    damageSource.setBaseImpact(2.0f);
                    livingentity.hurt((DamageSource)damageSource, 3.0f);
                }
            }
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_HORIZONTAL, (Object)true);
    }

    protected void setHorizontal(boolean setter) {
        this.getEntityData().set(DATA_HORIZONTAL, (Object)setter);
    }

    public boolean isHorizontal() {
        return (Boolean)this.getEntityData().get(DATA_HORIZONTAL);
    }

    public EntityDimensions getDimensions(Pose pose) {
        boolean horizontal = this.isHorizontal();
        float width = horizontal ? this.getRadius() * 2.0f : 1.0f;
        float height = horizontal ? 5.0f : this.getRadius() * 2.0f;
        return EntityDimensions.scalable((float)width, (float)height);
    }
}

