/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.item;

import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import yesman.epicfight.registry.entries.EpicFightDataComponentTypes;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

public class SkillBookItem
extends Item {
    public static void setContainingSkill(Holder<Skill> skill, ItemStack stack) {
        stack.applyComponents(DataComponentPatch.builder().set((DataComponentType)EpicFightDataComponentTypes.SKILL.get(), skill).build());
    }

    public static Optional<Holder<Skill>> getContainSkill(ItemStack stack) {
        return Optional.ofNullable((Holder)stack.get((DataComponentType)EpicFightDataComponentTypes.SKILL.get()));
    }

    public SkillBookItem(Item.Properties properties) {
        super(properties);
    }

    public boolean isFoil(ItemStack stack) {
        return stack.has((DataComponentType)EpicFightDataComponentTypes.SKILL.get());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (stack.has((DataComponentType)EpicFightDataComponentTypes.SKILL.get())) {
            Holder skill = (Holder)stack.get((DataComponentType)EpicFightDataComponentTypes.SKILL.get());
            ResourceLocation registryName = skill.getKey().location();
            tooltipComponents.add((Component)Component.translatable((String)String.format("skill.%s.%s", registryName.getNamespace(), registryName.getPath())).withStyle(ChatFormatting.DARK_GRAY));
        }
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        EpicFightCapabilities.getUnparameterizedEntityPatch((Entity)player, PlayerPatch.class).ifPresent(playerpatch -> playerpatch.openSkillBook(itemstack, hand));
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        return InteractionResultHolder.pass((Object)itemstack);
    }
}

