package dev.dubhe.anvilcraft.block;

import dev.dubhe.anvilcraft.api.block.IEmberBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class EmberMetalBlock extends Block implements IEmberBlock {
    private final double waterAbsorptionChance;
    private BlockState checkBlockState;

    public EmberMetalBlock(Properties properties, double waterAbsorptionChance) {
        super(properties);
        this.waterAbsorptionChance = waterAbsorptionChance;
    }

    @Override
    public boolean isRandomlyTicking(BlockState state) {
        return true;
    }

    @Override
    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (random.nextDouble() <= waterAbsorptionChance) {
            tryAbsorbWater(level, pos);
        }
    }

    public BlockState getCheckBlockState() {
        return this.checkBlockState;
    }

    public void setCheckBlockState(final BlockState checkBlockState) {
        this.checkBlockState = checkBlockState;
    }
}
