package dev.dubhe.anvilcraft.block.entity;

import dev.dubhe.anvilcraft.api.RipeningManager;
import dev.dubhe.anvilcraft.api.SpawningManager;
import dev.dubhe.anvilcraft.api.power.IPowerConsumer;
import dev.dubhe.anvilcraft.api.power.PowerGrid;
import dev.dubhe.anvilcraft.block.InductionLightBlock;
import dev.dubhe.anvilcraft.block.state.LightColor;
import dev.dubhe.anvilcraft.util.AabbUtil;
import dev.dubhe.anvilcraft.util.Lazy;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class InductionLightBlockEntity extends BlockEntity implements IPowerConsumer {
    public final Lazy<AABB> blockingArea = new Lazy<>(() -> AabbUtil.centerSectionTo3x3x3(this.getBlockPos()));
    private PowerGrid grid;
    private int rangeSize = 5;

    public InductionLightBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public static InductionLightBlockEntity createBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        return new InductionLightBlockEntity(type, pos, blockState);
    }

    public void tick(Level level1) {
        flushState(level1, getBlockPos());
        LightColor color = getBlockState().getValue(InductionLightBlock.COLOR);
        if (color == LightColor.PINK && InductionLightBlock.isLit(this.getBlockState())) {
            RipeningManager.from(level1).doRipen(getBlockPos());
        } else if (color == LightColor.YELLOW) {
            if (level != null) {
                SpawningManager.addLightBlock(getBlockPos(), level, false);
            }
        } else if (color == LightColor.DARK) {
            if (level != null) {
                SpawningManager.addLightBlock(getBlockPos(), level, true);
            }
        }
    }

    @Override
    public int getInputPower() {
        if (level == null) return 1;
        return getBlockState().getValue(InductionLightBlock.POWERED) ? 0 : getBlockState().getValue(InductionLightBlock.COLOR).dissipation;
    }

    @Override
    @Nullable
    public Level getCurrentLevel() {
        if (level != null) {
            return level;
        } else {
            return null;
        }
    }

    @Override
    public BlockPos getPos() {
        return getBlockPos();
    }

    public void setGrid(final PowerGrid grid) {
        this.grid = grid;
    }

    public void setRangeSize(final int rangeSize) {
        this.rangeSize = rangeSize;
    }

    public Lazy<AABB> getBlockingArea() {
        return this.blockingArea;
    }

    public PowerGrid getGrid() {
        return this.grid;
    }

    public int getRangeSize() {
        return this.rangeSize;
    }
}
