package dev.dubhe.anvilcraft.init;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import dev.dubhe.anvilcraft.AnvilCraft;
import dev.dubhe.anvilcraft.client.support.InspectionSupport;
import dev.dubhe.anvilcraft.network.InspectionStateChangedPacket;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import static net.minecraft.commands.Commands.literal;

public class ModInspections {
    private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(ModInspections.class);
    public static final ModInspections INSTANCE = new ModInspections();
    private final List<ResourceLocation> inspectionOptions = new ArrayList<>();

    public static void initialize() {
        INSTANCE.registerActionServer(AnvilCraft.of("silencer"));
    }

    /**
     * 注册检查项
     *
     * <p>检查项需同时在{@link ModInspections}和{@link InspectionSupport}中注册</p>
     *
     * <p>对于{@link InspectionSupport}，使用{@link InspectionSupport#registerActionClient} 注册检查项</p>
     *
     * @see InspectionSupport
     */
    public void registerActionServer(ResourceLocation id) {
        INSTANCE.inspectionOptions.add(id);
    }

    private int changeStateServer(ServerPlayer player, ResourceLocation id, boolean state) {
        PacketDistributor.sendToPlayer(player, new InspectionStateChangedPacket(id, state));
        return 0;
    }

    public void registerCommand(LiteralArgumentBuilder<CommandSourceStack> parent) {
        LiteralArgumentBuilder<CommandSourceStack> commandRoot = literal("inspection");
        for (ResourceLocation option : inspectionOptions) {
            commandRoot.then(literal(option.toString()).then(literal("enable").executes(ctx -> ctx.getSource().isPlayer() ? changeStateServer(Objects.requireNonNull(ctx.getSource().getPlayer()), option, true) : 0)).then(literal("disable").executes(ctx -> ctx.getSource().isPlayer() ? changeStateServer(Objects.requireNonNull(ctx.getSource().getPlayer()), option, false) : 0)));
        }
        parent.then(commandRoot);
    }
}
