package dev.dubhe.anvilcraft.inventory;

import dev.dubhe.anvilcraft.init.ModMenuTypes;
import dev.dubhe.anvilcraft.util.Callback;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SliderMenu extends AbstractContainerMenu {
    private final Callback<Integer> callback;

    public SliderMenu(@Nullable MenuType<?> menuType, int containerId) {
        super(menuType, containerId);
        this.callback = null;
    }

    public SliderMenu(int containerId, Callback<Integer> callback) {
        super(ModMenuTypes.SLIDER.get(), containerId);
        this.callback = callback;
    }

    @Override
    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        Slot sourceSlot = slots.get(index);
        // noinspection ConstantValue
        if (sourceSlot == null || !sourceSlot.hasItem()) return ItemStack.EMPTY;
        return sourceSlot.getItem();
    }

    @Override
    public boolean stillValid(@NotNull Player player) {
        return true;
    }

    public Callback<Integer> getCallback() {
        return this.callback;
    }
}
