package dev.dubhe.anvilcraft.api.entity.fakeplayer;

import com.mojang.authlib.GameProfile;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.IntFunction;

public class AnvilCraftDestroyerFakePlayer {
    static final IntFunction<GameProfile> FAKE_PROFILE_FACTORY = num -> new GameProfile(UUID.randomUUID(), "[Destroyer of AnvilCraft No." + num + "]");
    private static final Queue<Destroyer> DISABLED_DESTROYERS = new ConcurrentLinkedQueue<>();
    private static final List<Destroyer> ENABLED_DESTROYERS = Collections.synchronizedList(new ArrayList<>());
    private static ItemStack DUMMY_BREAK_TOOL = null;

    public AnvilCraftDestroyerFakePlayer() {
    }

    public ServerPlayer offerPlayer(ServerLevel level) {
        Destroyer destroyer = DISABLED_DESTROYERS.poll();
        if (destroyer == null) {
            destroyer = new Destroyer(level, ENABLED_DESTROYERS.size());
        }
        ENABLED_DESTROYERS.add(destroyer);
        return destroyer.getPlayer();
    }

    public void enabledDestroy(ServerPlayer player, ItemStack itemStack) {
        if (DUMMY_BREAK_TOOL == null) {
            DUMMY_BREAK_TOOL = itemStack;
        }
        player.setItemInHand(InteractionHand.MAIN_HAND, DUMMY_BREAK_TOOL.copy());
    }

    public void disable(ServerPlayer player) {
        ENABLED_DESTROYERS.stream().filter(destroyer -> destroyer.getUUID().equals(player.getUUID())).findFirst().ifPresent(destroyer -> {
            destroyer.getPlayer().setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
            DISABLED_DESTROYERS.offer(destroyer);
            ENABLED_DESTROYERS.remove(destroyer);
        });
    }


    public static final class Destroyer {
        private final GameProfile profile;
        private final ServerPlayer player;

        public Destroyer(ServerLevel level, int index) {
            this.profile = FAKE_PROFILE_FACTORY.apply(index + 1);
            this.player = FakePlayerFactory.get(level, this.profile);
        }

        public UUID getUUID() {
            return this.player.getUUID();
        }

        public GameProfile getProfile() {
            return this.profile;
        }

        public ServerPlayer getPlayer() {
            return this.player;
        }

        @Override
        public boolean equals(final Object o) {
            if (o == this) return true;
            if (!(o instanceof AnvilCraftDestroyerFakePlayer.Destroyer)) return false;
            final AnvilCraftDestroyerFakePlayer.Destroyer other = (AnvilCraftDestroyerFakePlayer.Destroyer) o;
            final Object this$profile = this.getProfile();
            final Object other$profile = other.getProfile();
            if (this$profile == null ? other$profile != null : !this$profile.equals(other$profile)) return false;
            final Object this$player = this.getPlayer();
            final Object other$player = other.getPlayer();
            if (this$player == null ? other$player != null : !this$player.equals(other$player)) return false;
            return true;
        }

        @Override
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final Object $profile = this.getProfile();
            result = result * PRIME + ($profile == null ? 43 : $profile.hashCode());
            final Object $player = this.getPlayer();
            result = result * PRIME + ($player == null ? 43 : $player.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "AnvilCraftDestroyerFakePlayer.Destroyer(profile=" + this.getProfile() + ", player=" + this.getPlayer() + ")";
        }
    }
}
