package dev.dubhe.anvilcraft.api.event;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.ICancellableEvent;

public class GuideBookEvent extends Event {

    public static class HasGuideBookEvent extends GuideBookEvent {
        private boolean hasGuideBook = false;

        public HasGuideBookEvent() {
        }

        public void hasGuideBook() {
            this.hasGuideBook = true;
        }

        public boolean isHasGuideBook() {
            return this.hasGuideBook;
        }
    }


    public static class OpenGuideBookEvent extends GuideBookEvent implements ICancellableEvent {
        private final Level level;
        private final ServerPlayer player;
        private final InteractionHand usedHand;

        public OpenGuideBookEvent(Level level, ServerPlayer player, InteractionHand usedHand) {
            this.level = level;
            this.player = player;
            this.usedHand = usedHand;
        }

        public Level getLevel() {
            return this.level;
        }

        public ServerPlayer getPlayer() {
            return this.player;
        }

        public InteractionHand getUsedHand() {
            return this.usedHand;
        }
    }
}
