package dev.dubhe.anvilcraft.api.tooltip;

import com.google.common.collect.Maps;
import dev.dubhe.anvilcraft.client.AnvilCraftClient;
import dev.dubhe.anvilcraft.client.init.ModKeyMappings;
import dev.dubhe.anvilcraft.init.block.ModBlocks;
import dev.dubhe.anvilcraft.init.item.ModComponents;
import dev.dubhe.anvilcraft.init.item.ModFoodItems;
import dev.dubhe.anvilcraft.init.item.ModItemTags;
import dev.dubhe.anvilcraft.init.item.ModItems;
import dev.dubhe.anvilcraft.item.property.component.Merciless;
import dev.dubhe.anvilcraft.util.ListUtil;
import dev.dubhe.anvilcraft.util.Util;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ItemTooltipManager {

    private static final Map<Item, String> map = Maps.newHashMap();

    static {
        map.put(ModItems.MAGNET.get(), "Attract surrounding items when use");
        map.put(ModItems.GEODE.get(), "Find the surrounding Amethyst Geode when using it");
        map.put(ModItems.ANVIL_HAMMER.get(), "It's a hammer, an anvil, a wrench, goggles, and a mace");
        map.put(ModItems.ROYAL_ANVIL_HAMMER.get(), "It's a hammer, an anvil, a wrench, goggles, and a mace");
        map.put(ModItems.EMBER_ANVIL_HAMMER.get(), "It's a hammer, an anvil, a wrench, goggles, and a mace");
        map.put(ModItems.TRANSCENDENCE_ANVIL_HAMMER.get(), "It's a hammer, an anvil, a wrench, goggles, and a mace");
        map.put(ModBlocks.CURSED_GOLD_BLOCK.asItem(), "Carriers will be cursed");
        map.put(ModItems.CURSED_GOLD_INGOT.get(), "Carriers will be cursed");
        map.put(ModItems.CURSED_GOLD_NUGGET.get(), "Carriers will be cursed");
        map.put(ModItems.TOPAZ.get(), "Containing the power of lightning");
        map.put(ModBlocks.RESIN_BLOCK.asItem(), "Use to capture friendly or weak hostile creatures LivingEntity");
        map.put(ModBlocks.CRAB_TRAP.asItem(), "Placing it in the water to help you catch aquatic products");
        map.put(ModItems.CRAB_CLAW.get(), "Increase touch length when holding");
        map.put(ModBlocks.ROYAL_ANVIL.asItem(), "Unbreakable and powerful compatibility");
        map.put(ModBlocks.ROYAL_GRINDSTONE.asItem(), "Explosion proof, Eliminating Curses and Punishing");
        map.put(ModBlocks.ROYAL_SMITHING_TABLE.asItem(), "Explosion proof, Saving your Smithing Template");
        map.put(ModBlocks.HEATER.asItem(), "Heating the block above, consumes 16 kW");
        map.put(ModBlocks.TRANSMISSION_POLE.asItem(), "Build a power grid with a transmission length of 8");
        map.put(ModBlocks.CHARGE_COLLECTOR.asItem(), "Collecting charges to generate power");
        map.put(ModBlocks.POWER_CONVERTER_SMALL.asItem(), "Convert power into FE, consumes 1 kW");
        map.put(ModBlocks.POWER_CONVERTER_MIDDLE.asItem(), "Convert power into FE, consumes 6 kW");
        map.put(ModBlocks.POWER_CONVERTER_BIG.asItem(), "Convert power into FE, consumes 36 kW");
        map.put(ModBlocks.PIEZOELECTRIC_CRYSTAL.asItem(), "Charge generated by an anvil fall on it");
        map.put(
            ModBlocks.MAGNET_BLOCK.asItem(),
            "Attracting the anvil below, when pushed and pulled by the piston, "
                + "causes adjacent copper blocks to generate charges"
        );
        map.put(
            ModBlocks.HOLLOW_MAGNET_BLOCK.asItem(),
            "Attracting the anvil below, "
                + "when pushed and pulled by the piston, causes adjacent copper blocks to generate charges"
        );
        map.put(
            ModBlocks.FERRITE_CORE_MAGNET_BLOCK.asItem(),
            "Attracting the anvil below, "
                + "when pushed and pulled by the piston, causes adjacent copper blocks to generate charges");
        map.put(
            ModBlocks.BATCH_CRAFTER.asItem(),
            "Received a redstone signal and synthesized all internal items at once, with a power consumption of 4 kW"
        );
        map.put(ModBlocks.ROYAL_STEEL_BLOCK.asItem(), "Explosion proof");
        map.put(ModBlocks.SMOOTH_ROYAL_STEEL_BLOCK.asItem(), "Explosion proof");
        map.put(ModBlocks.CUT_ROYAL_STEEL_BLOCK.asItem(), "Explosion proof");
        map.put(ModBlocks.CUT_ROYAL_STEEL_PILLAR.asItem(), "Explosion proof");
        map.put(ModBlocks.CUT_ROYAL_STEEL_STAIRS.asItem(), "Explosion proof");
        map.put(ModBlocks.CUT_ROYAL_STEEL_SLAB.asItem(), "Explosion proof");
        map.put(ModBlocks.TEMPERING_GLASS.asItem(), "Explosion proof, No tools required on collect");
        map.put(ModBlocks.REMOTE_TRANSMISSION_POLE.asItem(), "Build a power grid with a transmission length of 16");
        map.put(ModBlocks.HEAVY_IRON_BLOCK.asItem(), "Explosion proof");
        map.put(ModBlocks.POLISHED_HEAVY_IRON_BLOCK.asItem(), "Explosion proof");
        map.put(ModBlocks.POLISHED_HEAVY_IRON_SLAB.asItem(), "Explosion proof");
        map.put(ModBlocks.POLISHED_HEAVY_IRON_STAIRS.asItem(), "Explosion proof");
        map.put(ModBlocks.CUT_HEAVY_IRON_BLOCK.asItem(), "Explosion proof");
        map.put(ModBlocks.CUT_HEAVY_IRON_SLAB.asItem(), "Explosion proof");
        map.put(ModBlocks.CUT_HEAVY_IRON_STAIRS.asItem(), "Explosion proof");
        map.put(ModBlocks.HEAVY_IRON_PLATE.asItem(), "Explosion proof");
        map.put(ModBlocks.HEAVY_IRON_COLUMN.asItem(), "Explosion proof");
        map.put(ModBlocks.HEAVY_IRON_BEAM.asItem(), "Explosion proof");
        map.put(ModBlocks.HEAVY_IRON_WALL.asItem(), "Explosion proof");
        map.put(ModBlocks.HEAVY_IRON_DOOR.asItem(), "Explosion proof");
        map.put(ModBlocks.HEAVY_IRON_TRAPDOOR.asItem(), "Explosion proof");
        map.put(
            ModBlocks.ITEM_COLLECTOR.asItem(),
            "Adjust power consumption based on range and cooling" + ", from 2kW to 32kW"
        );
        map.put(ModBlocks.EMBER_ANVIL.asItem(), "Wither proof");
        map.put(ModBlocks.EMBER_GRINDSTONE.asItem(), "Wither proof");
        map.put(ModBlocks.EMBER_SMITHING_TABLE.asItem(), "Wither proof");
        map.put(ModBlocks.EMBER_METAL_BLOCK.asItem(), "Wither proof");
        map.put(ModBlocks.EMBER_GLASS.asItem(), "Wither proof, No tools required on collect");
        map.put(ModBlocks.CUT_EMBER_METAL_BLOCK.asItem(), "Wither proof");
        map.put(ModBlocks.CUT_EMBER_METAL_PILLAR.asItem(), "Wither proof");
        map.put(ModBlocks.CUT_EMBER_METAL_SLAB.asItem(), "Wither proof");
        map.put(ModBlocks.CUT_EMBER_METAL_STAIRS.asItem(), "Wither proof");

        map.put(ModItems.TIN_CAN.asItem(), "Tin cans can be combined with any food to obtain canned food");
        map.put(ModFoodItems.CANNED_FOOD.asItem(), "Stackable instant food");
        map.put(ModItems.IONOCRAFT.asItem(), "It will float when placed in the power grid");
        map.put(ModItems.IONOCRAFT_BACKPACK.asItem(), """
            When equipping to start flying like gamemode creative
            The backpack requires power supply from the grid or capacitors in the inventory for use""");
        map.put(ModItems.LEVITATION_POWDER.asItem(), "Slight weightlessness");
        map.put(ModItems.NEGATIVE_MATTER.asItem(), "Negative matter is not antimatter, it is anti gravity matter");
        map.put(ModItems.NEGATIVE_MATTER_NUGGET.asItem(), "Negative matter is not antimatter, it is anti gravity matter");
        map.put(ModBlocks.NEGATIVE_MATTER_BLOCK.asItem(), "Negative matter is not antimatter, it is anti gravity matter");
        map.put(ModItems.NEUTRONIUM_INGOT.asItem(), "Pass through most blocks except end dust, negative matter block, and bedrock");
        map.put(ModItems.STABLE_NEUTRONIUM_INGOT.asItem(), "No more passing through blocks");
        map.put(ModItems.CHARGED_NEUTRONIUM_INGOT.asItem(), "No longer passing through blocks, storing a large amount of electrical energy");
        map.put(ModBlocks.TESLA_TOWER.asItem(), "Electric shock to mobs or lightning rods within a range of 8 grids, with a power consumption of 128 kW");
        map.put(ModBlocks.INDUCTION_LIGHT.asItem(), """
            Lighting, with a power consumption of 1 kW
            Right click on this with Redstone to change it to ripening mode
            Right click on this with Glowstone Dust to change it to anti-monster spawning mode
            Right click on this with Void Matter to change it to anti-animal spawning mode
            The power consumption of the above three modes will become 16 kW""");
        map.put(ModBlocks.HELIOSTATS.asItem(), """
            Right click on the Netherite Block or Tungsten Block of the handheld heliostat to determine the irradiation point
            After placing it, it will heat the irradiated block during the day""");
        map.put(ModBlocks.ACTIVE_SILENCER.asItem(), "Eliminate selected nearby sounds");
        map.put(ModBlocks.BLOCK_PLACER.asItem(), """
            Redstone activation placed a block in front of this, but was hit by an anvil and placed further away.
            There is no stock available and items need to be retrieved from the blocks behind, fallen objects, or physical inventory""");
        map.put(ModBlocks.BLOCK_DEVOURER.asItem(), """
            Activated by redstone:
                Swallows blocks in a 3*3 range in front.
            Activated by an anvil:
                1 block -> 5 * 5
                2 blocks -> 7 * 7
            There is no inventory, and items will be inputted into the block or physical inventory behind or form falling objects behind.
            World base blocks such as stones, mud, lower bound rocks, and terminal stones will not drop 100%""");

        map.put(ModBlocks.COPPER_PRESSURE_PLATE.asItem(), "Redstone signal increases with pressing time, also a copper plate");
        map.put(ModBlocks.EXPOSED_COPPER_PRESSURE_PLATE.asItem(), "Redstone signal increases with pressing time, also a copper plate");
        map.put(ModBlocks.WEATHERED_COPPER_PRESSURE_PLATE.asItem(), "Redstone signal increases with pressing time, also a copper plate");
        map.put(ModBlocks.OXIDIZED_COPPER_PRESSURE_PLATE.asItem(), "Redstone signal increases with pressing time, also a copper plate");
        map.put(ModBlocks.ZINC_PRESSURE_PLATE.asItem(), "Output a redstone signal based on the highest percentage of health of the mobs above, also a zinc plate");
        map.put(ModBlocks.TIN_PRESSURE_PLATE.asItem(), "Output a redstone signal based on the lowest percentage of health of the mobs above, also a tin plate");
        map.put(ModBlocks.LEAD_PRESSURE_PLATE.asItem(), "Output redstone signal based on the number of biological species above, also a lead plateOutput redstone signal based on the number of mob species above, also a lead plate");
        map.put(ModBlocks.SILVER_PRESSURE_PLATE.asItem(), "Output redstone signal based on the number of undead mobs above, also a silver plate");
        map.put(ModBlocks.TUNGSTEN_PRESSURE_PLATE.asItem(), "Output redstone signal based on the number of fire-resistant entities above, also a tungsten plate");
        map.put(ModBlocks.TITANIUM_PRESSURE_PLATE.asItem(), "Output a redstone signal based on the highest durability of the items above, also a titanium plate");
        map.put(ModBlocks.URANIUM_PRESSURE_PLATE.asItem(), "Output a redstone signal based on the lowest durability of the items above, also a uranium plate");
        map.put(ModBlocks.PLUTONIUM_PRESSURE_PLATE.asItem(), "Output a redstone signal based on the player in hand item durability, also a plutonium plate");
        map.put(ModBlocks.BRONZE_PRESSURE_PLATE.asItem(), "Output a redstone signal based on player satiety above, also a bronze plate");
        map.put(ModBlocks.BRASS_PRESSURE_PLATE.asItem(), "Output a redstone signal based on the inventory's filling degree of player above, also a brass plate");
    }

    public static final Map<Item, String> NEED_TOOLTIP_ITEM = Collections.unmodifiableMap(map);

    /**
     * 为模组物品添加工具提示
     *
     * @param stack   需要添加工具提示的物品堆叠
     * @param tooltip 提示内容
     */
    public static void addTooltip(ItemStack stack, List<Component> tooltip) {
        final Item item = stack.getItem();
        if (stack.has(ModComponents.MULTIPHASE)) {
            if (AnvilCraftClient.CONFIG.showMultiphaseStoredId) {
                propertyTooltip(
                    "multiphase.id",
                    tooltip,
                    0xDD91FA,
                    stack.get(ModComponents.MULTIPHASE).id().toString()
                );
            }
            propertyTooltip(
                "multiphase",
                tooltip,
                0xDD91FA,
                ModKeyMappings.SWITCH_PHASE.get().getKey().getDisplayName()
            );
        }
        if (stack.has(ModComponents.PROVIDENCE)) {
            if (Screen.hasShiftDown()) {
                propertyTooltip("providence.shifting", tooltip, 0xFFCB62, ComponentUtils.formatList(
                    List.of(
                        Component.translatable("enchantment.minecraft.fortune"),
                        Component.translatable("enchantment.minecraft.looting"),
                        Component.translatable("enchantment.anvilcraft.beheading"),
                        Component.translatable("enchantment.minecraft.thorns"),
                        Component.translatable("enchantment.minecraft.luck_of_the_sea")
                    ), ComponentUtils.DEFAULT_NO_STYLE_SEPARATOR));
            } else {
                propertyTooltip(
                    "providence", tooltip, 0xFFCB62,
                    Minecraft.getInstance().options.keyShift.getKey().getDisplayName());
            }
        }
        if (stack.has(ModComponents.ETERNAL)) {
            propertyTooltip("eternal", tooltip, 0xD3C5F6);
        }
        if (stack.getOrDefault(ModComponents.MERCILESS, Merciless.DISABLED).enabled()) {
            if (!Screen.hasShiftDown()) {
                propertyTooltip(
                    "merciless", tooltip, 0xB4F0F6,
                    Minecraft.getInstance().options.keyShift.getKey().getDisplayName());
            } else {
                propertyTooltip("merciless.shifting", tooltip, 0xB4F0F6, ComponentUtils.formatList(
                    List.of(
                        Component.translatable("enchantment.minecraft.loyalty"),
                        Component.translatable("enchantment.minecraft.riptide"),
                        Component.translatable("tooltip.anvilcraft.property.merciless.curse")
                    ), ComponentUtils.DEFAULT_NO_STYLE_SEPARATOR));
            }
        }
        if (stack.has(ModComponents.FIRE_REFORGING)) {
            propertyTooltip("fire_reforging", tooltip, ChatFormatting.GOLD);
        }
        if (NEED_TOOLTIP_ITEM.containsKey(item)) {
            tooltip.add(1, getItemTooltip(item));
        }
        if (stack.is(ModItemTags.REINFORCED_CONCRETE)) {
            ResourceLocation key = BuiltInRegistries.ITEM.getKey(item);
            tooltip.add(
                1,
                Component.translatable("tooltip.%s.item.reinforced_concrete".formatted(key.getNamespace()))
                    .withStyle(ChatFormatting.GRAY)
            );
        }
    }

    private static Component getItemTooltip(Item item) {
        return Component.translatable(getTranslationKey(item)).withStyle(ChatFormatting.GRAY);
    }

    public static String getTranslationKey(Item item) {
        ResourceLocation key = BuiltInRegistries.ITEM.getKey(item);
        return "tooltip.%s.item.%s".formatted(key.getNamespace(), key.getPath());
    }

    private static void propertyTooltip(String propertyName, List<Component> tooltip, ChatFormatting color) {
        int i = 0;
        for (int j = 0; j < tooltip.size(); j++) {
            if (tooltip.get(j).getContents() instanceof TranslatableContents t && t.getKey().contains("enchantment")
                && ListUtil.safelyGet(tooltip, j + 1)
                .flatMap(tooltipI -> Util.castSafely(tooltipI.getContents(), TranslatableContents.class))
                .map(TranslatableContents::getKey)
                .filter(key -> key.contains("enchantment"))
                .isEmpty()
            ) {
                i = j;
                break;
            }
        }
        tooltip.add(
            1 + i,
            Component.translatable("tooltip.anvilcraft.property.%s".formatted(propertyName)).withStyle(color)
        );
    }

    private static void propertyTooltip(String propertyName, List<Component> tooltip, int color) {
        int i = 0;
        for (int j = 0; j < tooltip.size(); j++) {
            if (tooltip.get(j).getContents() instanceof TranslatableContents t && t.getKey().contains("enchantment")
                && ListUtil.safelyGet(tooltip, j + 1)
                .flatMap(tooltipI -> Util.castSafely(tooltipI.getContents(), TranslatableContents.class))
                .map(TranslatableContents::getKey)
                .filter(key -> key.contains("enchantment"))
                .isEmpty()
            ) {
                i = j;
                break;
            }
        }
        tooltip.add(
            1 + i,
            Component.translatable("tooltip.anvilcraft.property.%s".formatted(propertyName)).withColor(color)
        );
    }

    private static void propertyTooltip(String propertyName, List<Component> tooltip, int color, Object... args) {
        int i = 0;
        for (int j = 0; j < tooltip.size(); j++) {
            if (tooltip.get(j).getContents() instanceof TranslatableContents t && t.getKey().contains("enchantment")
                && ListUtil.safelyGet(tooltip, j + 1)
                .flatMap(tooltipI -> Util.castSafely(tooltipI.getContents(), TranslatableContents.class))
                .map(TranslatableContents::getKey)
                .filter(key -> key.contains("enchantment"))
                .isEmpty()
            ) {
                i = j;
                break;
            }
        }
        tooltip.add(
            1 + i,
            Component.translatable("tooltip.anvilcraft.property.%s".formatted(propertyName), args).withColor(color)
        );
    }
}
