package dev.dubhe.anvilcraft.data.advancement;

import com.tterrag.registrate.providers.RegistrateAdvancementProvider;
import dev.dubhe.anvilcraft.init.ModAdvancements;
import dev.dubhe.anvilcraft.util.Util;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class AnvilCraftAdvancement {
    public static void init(RegistrateAdvancementProvider provider) {
        try {
            for (Field field : ModAdvancements.class.getDeclaredFields()) {
                int modifiers = field.getModifiers();
                if (Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers)) {
                    provider.accept(Util.cast(field.get(null)));
                }
            }
        } catch (final java.lang.Throwable $ex) {
            throw lombok.Lombok.sneakyThrow($ex);
        }
    }
}
