package dev.dubhe.anvilcraft.api.event;

import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.Event;

public class BlockEntityEvent extends Event {
    private final Level level;
    private final BlockEntity entity;

    public BlockEntityEvent(Level level, BlockEntity entity) {
        this.level = level;
        this.entity = entity;
    }


    public static class ServerLoad extends BlockEntityEvent {
        public ServerLoad(Level level, BlockEntity entity) {
            super(level, entity);
        }
    }


    public static class ServerUnload extends BlockEntityEvent {
        public ServerUnload(Level level, BlockEntity entity) {
            super(level, entity);
        }
    }

    public Level getLevel() {
        return this.level;
    }

    public BlockEntity getEntity() {
        return this.entity;
    }
}
