package dev.dubhe.anvilcraft.api.event;

import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.ICancellableEvent;
import net.neoforged.fml.event.IModBusEvent;

public class UseMagnetEvent extends Event implements ICancellableEvent, IModBusEvent {
    private final Level level;
    private double attractRadius;
    private final Player player;

    public UseMagnetEvent(Level level, Player player, double attractRadius) {
        this.level = level;
        this.attractRadius = attractRadius;
        this.player = player;
    }

    public Level getLevel() {
        return this.level;
    }

    public double getAttractRadius() {
        return this.attractRadius;
    }

    public Player getPlayer() {
        return this.player;
    }

    public void setAttractRadius(final double attractRadius) {
        this.attractRadius = attractRadius;
    }
}
