package dev.dubhe.anvilcraft.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.TriState;
import org.jetbrains.annotations.Nullable;

public class ActivatorSlidingRailBlockEntity extends BlockEntity {
    private TriState shouldPower = TriState.DEFAULT;

    public ActivatorSlidingRailBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    @Override
    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create(this);
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag data = super.getUpdateTag(registries);
        data.putInt("ShouldPower", this.shouldPower.ordinal());
        return data;
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("ShouldPower", this.shouldPower.ordinal());
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.shouldPower = TriState.values()[tag.getInt("ShouldPower")];
    }

    public boolean shouldPower() {
        return this.shouldPower != TriState.FALSE;
    }

    public void stopPulse() {
        this.shouldPower = TriState.FALSE;
    }

    public void startPulse() {
        this.shouldPower = TriState.TRUE;
    }

    public void backToDefault() {
        this.shouldPower = TriState.DEFAULT;
    }

    public TriState getShouldPower() {
        return this.shouldPower;
    }
}
