package dev.dubhe.anvilcraft.util.mixins.minecraft;

import dev.dubhe.anvilcraft.item.IntrinsicEnchantedItem;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class MMItemStack {
    public static boolean intrinsicEnch(ItemStack self, boolean original) {
        return original || self.getItem() instanceof IntrinsicEnchantedItem item && !item.intrinsicEnchantments(self).isEmpty();
    }

    private MMItemStack() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}
