package dev.dubhe.anvilcraft.api.event;

import dev.dubhe.anvilcraft.entity.FallingGiantAnvilEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.ICancellableEvent;
import net.neoforged.neoforge.event.entity.EntityEvent;

public class AnvilEvent extends EntityEvent {
    private final FallingBlockEntity entity;

    public AnvilEvent(FallingBlockEntity entity) {
        super(entity);
        this.entity = entity;
    }


    public static class OnLand extends AnvilEvent {
        private final Level level;
        private final BlockPos pos;
        private final float fallDistance;
        private boolean isAnvilDamage = false;

        /**
         * 铁砧落地事件
         *
         * @param level        世界
         * @param pos          位置
         * @param entity       铁砧
         * @param fallDistance 下落距离
         */
        public OnLand(Level level, BlockPos pos, FallingBlockEntity entity, float fallDistance) {
            super(entity);
            this.level = level;
            this.pos = pos;
            this.fallDistance = fallDistance;
        }

        public Level getLevel() {
            return this.level;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public float getFallDistance() {
            return this.fallDistance;
        }

        public boolean isAnvilDamage() {
            return this.isAnvilDamage;
        }

        public void setAnvilDamage(final boolean isAnvilDamage) {
            this.isAnvilDamage = isAnvilDamage;
        }
    }


    public static class CollisionBlock extends AnvilEvent implements ICancellableEvent {
        private final Level level;
        private final BlockPos pos;
        private final double speed;
        private boolean isAnvilDamage = false;

        /**
         * 铁砧落地事件
         *
         * @param level  世界
         * @param pos    位置
         * @param entity 铁砧
         * @param speed  撞击速度
         */
        public CollisionBlock(Level level, BlockPos pos, FallingBlockEntity entity, double speed) {
            super(entity);
            this.level = level;
            this.pos = pos;
            this.speed = speed;
        }

        public Level getLevel() {
            return this.level;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public double getSpeed() {
            return this.speed;
        }

        public boolean isAnvilDamage() {
            return this.isAnvilDamage;
        }

        public void setAnvilDamage(final boolean isAnvilDamage) {
            this.isAnvilDamage = isAnvilDamage;
        }
    }


    public static class GiantOnLand extends AnvilEvent {
        private final Level level;
        private final BlockPos pos;
        private final float fallDistance;
        private final FallingGiantAnvilEntity entity;
        private boolean isAnvilDamage = false;

        /**
         * 铁砧落地事件
         *
         * @param level        世界
         * @param pos          位置
         * @param entity       铁砧
         * @param fallDistance 下落距离
         */
        public GiantOnLand(Level level, BlockPos pos, FallingGiantAnvilEntity entity, float fallDistance) {
            super(entity);
            this.level = level;
            this.pos = pos;
            this.fallDistance = fallDistance;
            this.entity = entity;
        }

        public Level getLevel() {
            return this.level;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public float getFallDistance() {
            return this.fallDistance;
        }

        public FallingGiantAnvilEntity getEntity() {
            return this.entity;
        }

        public boolean isAnvilDamage() {
            return this.isAnvilDamage;
        }

        public void setAnvilDamage(final boolean isAnvilDamage) {
            this.isAnvilDamage = isAnvilDamage;
        }
    }


    public static class HurtEntity extends AnvilEvent {
        private final BlockPos pos;
        private final Level level;
        private final Entity hurtedEntity;
        private final float damage;

        /**
         * 铁砧伤害实体
         *
         * @param entity       铁砧
         * @param pos          位置
         * @param level        世界
         * @param hurtedEntity 被伤害的实体
         * @param damage       伤害
         */
        public HurtEntity(FallingBlockEntity entity, BlockPos pos, Level level, Entity hurtedEntity, float damage) {
            super(entity);
            this.pos = pos;
            this.level = level;
            this.hurtedEntity = hurtedEntity;
            this.damage = damage;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public Level getLevel() {
            return this.level;
        }

        public Entity getHurtedEntity() {
            return this.hurtedEntity;
        }

        public float getDamage() {
            return this.damage;
        }
    }

    public FallingBlockEntity getEntity() {
        return this.entity;
    }
}
