package dev.dubhe.anvilcraft.item;

import dev.dubhe.anvilcraft.block.entity.TeslaTowerBlockEntity;
import dev.dubhe.anvilcraft.block.item.SimpleMultiPartBlockItem;
import dev.dubhe.anvilcraft.block.multipart.SimpleMultiPartBlock;
import dev.dubhe.anvilcraft.block.state.Vertical4PartHalf;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class TeslaTowerItem extends SimpleMultiPartBlockItem<Vertical4PartHalf> {
    public TeslaTowerItem(SimpleMultiPartBlock<Vertical4PartHalf> block, Properties properties) {
        super(block, properties);
    }

    @Override
    protected boolean updateCustomBlockEntityTag(
        BlockPos pos,
        Level level,
        @Nullable Player player,
        ItemStack stack,
        BlockState state) {
        if (!(level.getBlockEntity(pos) instanceof TeslaTowerBlockEntity teslaTowerBlockEntity)) return false;
        if (player == null) return false;
        teslaTowerBlockEntity.initWhiteList(player);
        return true;
    }
}
