package dev.dubhe.anvilcraft.util.mixin;

public final class PoachFix {
    private static final String NO_POACH_METHOD_NAME = "shouldNotPoach_PreVeNTDUpLICatioN";

    public static boolean shouldItPoach() {
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        for (StackTraceElement element : elements) {
            if (element.getMethodName().contains(NO_POACH_METHOD_NAME)) return false;
        }
        return true;
    }

    private PoachFix() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}
