package dev.dubhe.anvilcraft.client.gui.screen;

import dev.dubhe.anvilcraft.client.gui.component.OutputDirectionButton;
import dev.dubhe.anvilcraft.network.MachineOutputDirectionPacket;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import java.util.Arrays;
import java.util.function.BiFunction;

public abstract class BaseMachineScreen<T extends AbstractContainerMenu> extends AbstractContainerScreen<T> {
    private BiFunction<Integer, Integer, OutputDirectionButton> directionButtonSupplier;
    private OutputDirectionButton directionButton = null;
    private final Player player;

    /**
     * 基本机器 GUI
     *
     * @param menu      菜单
     * @param inventory 玩家背包
     * @param title     标题
     */
    public BaseMachineScreen(T menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
        this.directionButtonSupplier = BaseMachineScreen.getDirectionButtonSupplier(134, 18);
        this.player = inventory.player;
    }

    @Override
    protected void init() {
        super.init();
        this.titleLabelX = (this.imageWidth - this.font.width(this.title)) / 2;
        this.directionButton = directionButtonSupplier.apply(this.leftPos, this.topPos);
        this.addRenderableWidget(directionButton);
    }

    @Contract(pure = true)
    @NotNull
    protected static BiFunction<Integer, Integer, OutputDirectionButton> getDirectionButtonSupplier(int x, int y, Direction... skip) {
        return (i, j) -> new OutputDirectionButton(i + x, j + y, button -> {
            if (button instanceof OutputDirectionButton button1) {
                Arrays.stream(skip).forEach(button1::skip);
                MachineOutputDirectionPacket packet = new MachineOutputDirectionPacket(button1.next());
                PacketDistributor.sendToServer(packet);
            }
        }, Direction.DOWN);
    }

    @Override
    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    public void setDirectionButtonSupplier(final BiFunction<Integer, Integer, OutputDirectionButton> directionButtonSupplier) {
        this.directionButtonSupplier = directionButtonSupplier;
    }

    public OutputDirectionButton getDirectionButton() {
        return this.directionButton;
    }

    public Player getPlayer() {
        return this.player;
    }
}
