package dev.dubhe.anvilcraft.item;

import dev.dubhe.anvilcraft.init.enchantment.ModEnchantments;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;

public class AmethystSwordItem extends SwordItem {
    public AmethystSwordItem(Properties properties) {
        super(ModTiers.AMETHYST, properties.attributes(SwordItem.createAttributes(ModTiers.AMETHYST, 3, -2.4f)));
    }

    @Override
    public void onCraftedPostProcess(ItemStack stack, Level level) {
        ItemEnchantments.Mutable enchantments = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
        enchantments.set(level.registryAccess().holderOrThrow(ModEnchantments.BEHEADING_KEY), 1);
        stack.set(DataComponents.ENCHANTMENTS, enchantments.toImmutable());
    }
}
