package dev.dubhe.anvilcraft.client.init;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import dev.dubhe.anvilcraft.AnvilCraft;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.neoforged.neoforge.client.event.RegisterShadersEvent;
import org.joml.Matrix4f;
import java.io.IOException;

public class ModShaders {
    public static final ResourceLocation LASER_BLOOM_LOCATION = ResourceLocation.fromNamespaceAndPath("anvilcraft", "shaders/post/bloom.json");
    private static PostChain bloomChain;
    static final Minecraft MINECRAFT = Minecraft.getInstance();
    static ShaderInstance renderTypeLaserShader;
    static ShaderInstance renderTypeColoredOverlayShader;
    static ShaderInstance ringShader;
    static ShaderInstance selectionShader;
    static ShaderInstance blitShader;
    static Matrix4f orthoMatrix = new Matrix4f();

    public static void register(RegisterShadersEvent event) {
        try {
            event.registerShader(new ShaderInstance(event.getResourceProvider(), AnvilCraft.of("rendertype_laser"), DefaultVertexFormat.BLOCK), it -> renderTypeLaserShader = it);
            event.registerShader(new ShaderInstance(event.getResourceProvider(), AnvilCraft.of("rendertype_translucent_colored_overlay"), DefaultVertexFormat.BLOCK), it -> renderTypeColoredOverlayShader = it);
            event.registerShader(new ShaderInstance(event.getResourceProvider(), AnvilCraft.of("ring"), DefaultVertexFormat.POSITION_COLOR), it -> ringShader = it);
            event.registerShader(new ShaderInstance(event.getResourceProvider(), AnvilCraft.of("selection"), DefaultVertexFormat.POSITION_COLOR), it -> selectionShader = it);
            event.registerShader(new ShaderInstance(event.getResourceProvider(), AnvilCraft.of("blit"), DefaultVertexFormat.POSITION), it -> blitShader = it);
        } catch (Exception e) {
            AnvilCraft.LOGGER.error("Shader loading has failed.", e);
        }
    }

    public static void resize(int width, int height) {
        if (bloomChain != null) {
            bloomChain.resize(width, height);
        }
        orthoMatrix = new Matrix4f().setOrtho(0.0F, width, 0.0F, height, 0.1F, 1000.0F);
    }

    public static void loadBloomEffect(ResourceProvider resourceProvider) throws IOException {
        try {
            bloomChain = new PostChain(MINECRAFT.getTextureManager(), resourceProvider, Minecraft.getInstance().getMainRenderTarget(), LASER_BLOOM_LOCATION);
            bloomChain.resize(Minecraft.getInstance().getWindow().getWidth(), Minecraft.getInstance().getWindow().getHeight());
            ModRenderTargets.renderTargetLoaded(bloomChain.getTempTarget("input"));
        } catch (Throwable tr) {
            AnvilCraft.LOGGER.error("Could not load bloom effect shader.", tr);
        }
    }

    public static PostChain getBloomChain() {
        return ModShaders.bloomChain;
    }

    public static ShaderInstance getRenderTypeLaserShader() {
        return ModShaders.renderTypeLaserShader;
    }

    public static ShaderInstance getRingShader() {
        return ModShaders.ringShader;
    }

    public static ShaderInstance getSelectionShader() {
        return ModShaders.selectionShader;
    }

    public static ShaderInstance getBlitShader() {
        return ModShaders.blitShader;
    }

    public static Matrix4f getOrthoMatrix() {
        return ModShaders.orthoMatrix;
    }
}
