package dev.dubhe.anvilcraft.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import dev.dubhe.anvilcraft.api.event.AnvilEvent;
import dev.dubhe.anvilcraft.api.injection.entity.IFallingBlockEntityExtension;
import dev.dubhe.anvilcraft.init.block.ModBlocks;
import dev.dubhe.anvilcraft.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.EntityHitResult;
import net.neoforged.neoforge.common.NeoForge;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.List;
import java.util.function.Predicate;

@Mixin(FallingBlockEntity.class)
abstract class FallingBlockEntityMixin extends Entity implements IFallingBlockEntityExtension {
    @Unique
    private static final float DAMAGE_FACTOR = 40 / 1.7444f;

    @Shadow
    public BlockState blockState;

    @Shadow
    public boolean cancelDrop;

    @Shadow
    private float fallDamagePerDistance;
    @Shadow
    private int fallDamageMax;
    @Unique
    private float anvilcraft$fallDistance;

    public FallingBlockEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(
        method = "tick",
        at =
        @At(
            value = "INVOKE",
            ordinal = 0,
            target = "Lnet/minecraft/world/entity/item/FallingBlockEntity;level()Lnet/minecraft/world/level/Level;"
        )
    )
    private void anvilPerFallOnGround(CallbackInfo ci) {
        if (this.level().isClientSide()) return;
        if (this.onGround()) return;
        this.anvilcraft$fallDistance = this.fallDistance;
    }

    @Override
    public float anvilcraft$getFallDistance() {
        return this.anvilcraft$fallDistance;
    }

    @SuppressWarnings("UnreachableCode")
    @Inject(
        method = "tick",
        at =
        @At(
            value = "INVOKE",
            target = "Lnet/minecraft/world/level/block/Fallable;"
                     + "onLand("
                     + "Lnet/minecraft/world/level/Level;"
                     + "Lnet/minecraft/core/BlockPos;"
                     + "Lnet/minecraft/world/level/block/state/BlockState;"
                     + "Lnet/minecraft/world/level/block/state/BlockState;"
                     + "Lnet/minecraft/world/entity/item/FallingBlockEntity;"
                     + ")V"
        )
    )
    private void anvilFallOnGround(CallbackInfo ci, @Local BlockPos blockPos) {
        if (this.level().isClientSide()) return;
        if (!this.blockState.is(BlockTags.ANVIL)) return;
        FallingBlockEntity entity = Util.cast(this);
        AnvilEvent.OnLand event = new AnvilEvent.OnLand(this.level(), blockPos, entity, this.anvilcraft$fallDistance);
        NeoForge.EVENT_BUS.post(event);
        if (event.isAnvilDamage()) {
            BlockState state = this.blockState.is(ModBlocks.ROYAL_ANVIL.get())
                               ? this.blockState
                               : AnvilBlock.damage(this.blockState);
            if (state != null) {
                this.level().setBlockAndUpdate(blockPos, state);
            } else {
                this.level().setBlockAndUpdate(blockPos, Blocks.AIR.defaultBlockState());
                if (!this.isSilent()) this.level().levelEvent(1029, this.getOnPos(), 0);
                this.cancelDrop = true;
            }
        }
    }

    @SuppressWarnings("UnreachableCode")
    @Inject(
        method = "causeFallDamage",
        at =
        @At(
            value = "INVOKE",
            target = "Lnet/minecraft/world/level/Level;"
                     + "getEntities("
                     + "Lnet/minecraft/world/entity/Entity;"
                     + "Lnet/minecraft/world/phys/AABB;"
                     + "Ljava/util/function/Predicate;"
                     + ")Ljava/util/List;"
        )
    )
    private void anvilHurtEntity(
        float pFallDistance,
        float pMultiplier,
        DamageSource pSource,
        CallbackInfoReturnable<Boolean> cir
    ) {
        Level level = this.level();
        FallingBlockEntity fallingBlockEntity = Util.cast(this);
        Predicate<Entity> predicate = EntitySelector.NO_CREATIVE_OR_SPECTATOR.and(EntitySelector.LIVING_ENTITY_STILL_ALIVE);
        int i = Mth.ceil(this.fallDistance - 1.0F);
        float f = (float) Math.min(Mth.floor((float) i * this.fallDamagePerDistance), this.fallDamageMax);
        if (fallingBlockEntity.getBlockState().is(BlockTags.ANVIL)) {
            List<Entity> entities = level.getEntities(this, this.getBoundingBox(), predicate);
            for (Entity entity : entities) {
                NeoForge.EVENT_BUS.post(new AnvilEvent.HurtEntity(fallingBlockEntity, this.getOnPos(), level, entity, f));
            }
        }
    }

    @Inject(
        method = "tick",
        at =
        @At(
            value = "INVOKE",
            target = "Lnet/minecraft/world/entity/item/FallingBlockEntity;setDeltaMovement(Lnet/minecraft/world/phys/Vec3;)V",
            ordinal = 1
        )
    )
    private void hurtEntity(CallbackInfo ci) {
        if (
            this.getDeltaMovement().multiply(1, 0, 1).length() < 0.75
            && this.getDeltaMovement().y < 2.5
        ) {
            return;
        }
        if (!this.blockState.is(BlockTags.ANVIL)) return;
        EntityHitResult hitResult = ProjectileUtil.getEntityHitResult(
            this.level(),
            this,
            this.position().subtract(0, 0.5, 0).subtract(
                this.anvilcraft$isDeflected() ? this.anvilcraft$getFixedDeltaMovement() : this.getDeltaMovement()
            ),
            this.position().subtract(0, 0.5, 0),
            this.getBoundingBox()
                .expandTowards(
                    (
                        this.anvilcraft$isDeflected()
                        ? this.anvilcraft$getFixedDeltaMovement()
                        : this.getDeltaMovement()
                    ).multiply(-1, -1, -1)
                )
                .inflate(1.0),
            Entity::isAttackable
        );
        if (hitResult == null) return;
        if (hitResult.getType() != EntityHitResult.Type.ENTITY) return;
        float hurtAmount = (float) (this.getDeltaMovement().length() * DAMAGE_FACTOR);
        hitResult.getEntity().hurt(damageSources().anvil(this), hurtAmount);
    }
}
