/*
 * Decompiled with CFR 0.152.
 */
package com.lne_wizards.effect;

import com.lne_wizards.effect.ArcanePrecisionEffect;
import com.lne_wizards.effect.CustomStatusEffect;
import com.lne_wizards.effect.FlameRushStatusEffect;
import java.util.ArrayList;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.more_rpg_classes.custom.MoreSpellSchools;
import net.spell_engine.api.effect.Synchronized;
import net.spell_power.api.SpellPower;
import net.spell_power.api.SpellPowerMechanics;
import net.spell_power.api.SpellSchools;

public class Effects {
    private static final ArrayList<Entry> entries = new ArrayList();
    public static final Entry ARCANE_PRECISION = new Entry("arcane_precision", (MobEffect)new ArcanePrecisionEffect(MobEffectCategory.HARMFUL, SpellSchools.ARCANE.color).setVulnerability(SpellSchools.ARCANE, new SpellPower.Vulnerability(0.025f, 0.05f, 0.1f)));
    public static final Entry FLAME_RUSH = new Entry("flame_rush", new FlameRushStatusEffect(MobEffectCategory.BENEFICIAL, SpellSchools.FIRE.color));
    public static final Entry ZEPHYRS_SPEED = new Entry("zephyrs_speed", new CustomStatusEffect(MobEffectCategory.BENEFICIAL, MoreSpellSchools.AIR.color));

    public static void register() {
        Effects.FLAME_RUSH.effect.addAttributeModifier(Attributes.MOVEMENT_SPEED, FLAME_RUSH.modifierId(), 0.75, AttributeModifier.Operation.ADD_MULTIPLIED_BASE).addAttributeModifier(SpellSchools.FIRE.attributeEntry, FLAME_RUSH.modifierId(), (double)0.1f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
        Effects.ZEPHYRS_SPEED.effect.addAttributeModifier(Attributes.MOVEMENT_SPEED, ZEPHYRS_SPEED.modifierId(), (double)0.05f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE).addAttributeModifier(SpellPowerMechanics.CRITICAL_CHANCE.attributeEntry, ZEPHYRS_SPEED.modifierId(), (double)0.03f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
        Synchronized.configure((MobEffect)Effects.ARCANE_PRECISION.effect, (boolean)true);
        Synchronized.configure((MobEffect)Effects.FLAME_RUSH.effect, (boolean)true);
        Synchronized.configure((MobEffect)Effects.ZEPHYRS_SPEED.effect, (boolean)true);
        for (Entry entry : entries) {
            entry.register();
        }
    }

    public static class Entry {
        public final ResourceLocation id;
        public final MobEffect effect;
        public Holder<MobEffect> registryEntry;

        public Entry(String name, MobEffect effect) {
            this.id = ResourceLocation.fromNamespaceAndPath((String)"lne_wizards", (String)name);
            this.effect = effect;
            entries.add(this);
        }

        public void register() {
            this.registryEntry = Registry.registerForHolder((Registry)BuiltInRegistries.MOB_EFFECT, (ResourceLocation)this.id, (Object)this.effect);
        }

        public ResourceLocation modifierId() {
            return ResourceLocation.fromNamespaceAndPath((String)"lne_wizards", (String)("effect." + this.id.getPath()));
        }
    }
}

