/*
 * Decompiled with CFR 0.152.
 */
package com.lne_wizards.item;

import com.lne_wizards.LNE_Wizards_Mod;
import com.lne_wizards.config.TweaksConfig;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Supplier;
import more_rpg_loot.item.Group;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.more_rpg_classes.custom.MoreSpellSchools;
import net.spell_engine.api.config.AttributeModifier;
import net.spell_engine.api.config.WeaponConfig;
import net.spell_engine.api.item.Equipment;
import net.spell_engine.api.item.weapon.StaffItem;
import net.spell_engine.api.item.weapon.Weapon;
import net.spell_power.api.SpellSchools;

public class WeaponRegister {
    public static final ArrayList<Weapon.Entry> entries = new ArrayList();
    private static final float staffAttackDamage = 4.0f;
    private static final float staffAttackSpeed = -3.0f;
    private static final float staffSpellPower = 7.0f;
    public static ResourceLocation rimefrost = ResourceLocation.fromNamespaceAndPath((String)"lne_wizards", (String)"rimefrost");
    public static ResourceLocation pyromaniac = ResourceLocation.fromNamespaceAndPath((String)"lne_wizards", (String)"pyromaniac");
    public static ResourceLocation arcane_precision = ResourceLocation.fromNamespaceAndPath((String)"lne_wizards", (String)"arcane_precision");
    public static ResourceLocation water_flow = ResourceLocation.fromNamespaceAndPath((String)"lne_wizards", (String)"water_flow");
    public static ResourceLocation obsidian_shards = ResourceLocation.fromNamespaceAndPath((String)"lne_wizards", (String)"obsidian_shards");
    public static ResourceLocation zephyrs_speed = ResourceLocation.fromNamespaceAndPath((String)"lne_wizards", (String)"zephyrs_speed");

    private static Weapon.Entry entry(String name, Weapon.CustomMaterial material, Weapon.Factory factory, WeaponConfig defaults, Equipment.WeaponType type) {
        Weapon.Entry entry = new Weapon.Entry("lne_wizards", name, material, factory, defaults, type);
        entry.castSpell();
        entries.add(entry);
        return entry;
    }

    private static Supplier<Ingredient> ingredient(String idString, boolean requirement, Item fallback) {
        ResourceLocation id = ResourceLocation.parse((String)idString);
        if (requirement) {
            return () -> Ingredient.of((ItemLike[])new ItemLike[]{fallback});
        }
        return () -> {
            Item item = (Item)BuiltInRegistries.ITEM.get(id);
            Item ingredient = item != null ? item : fallback;
            return Ingredient.of((ItemLike[])new ItemLike[]{ingredient});
        };
    }

    private static Weapon.Entry staff(String name, Weapon.CustomMaterial material) {
        return WeaponRegister.entry(name, material, StaffItem::new, new WeaponConfig(4.0f, -3.0f), Equipment.WeaponType.DAMAGE_STAFF);
    }

    public static void register(Map<String, WeaponConfig> configs) {
        if (!((TweaksConfig)LNE_Wizards_Mod.tweaksConfig.value).disable_special_lne_weapons) {
            WeaponRegister.staff("glacial_staff_frost", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.ICE}))).attribute(AttributeModifier.bonus((ResourceLocation)SpellSchools.FROST.id, (float)7.0f)).spell(rimefrost);
            WeaponRegister.staff("wither_staff_fire", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.BONE}))).attribute(AttributeModifier.bonus((ResourceLocation)SpellSchools.FIRE.id, (float)7.0f)).spell(pyromaniac);
            WeaponRegister.staff("ender_dragon_staff_arcane", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.AMETHYST_SHARD}))).attribute(AttributeModifier.bonus((ResourceLocation)SpellSchools.ARCANE.id, (float)7.0f)).spell(arcane_precision);
        }
        if (!((TweaksConfig)LNE_Wizards_Mod.tweaksConfig.value).disable_special_lne_weapons && FabricLoader.getInstance().isModLoaded("elemental_wizards_rpg")) {
            WeaponRegister.staff("elder_guardian_staff_aqua", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.PRISMARINE_SHARD}))).attribute(AttributeModifier.bonus((ResourceLocation)MoreSpellSchools.WATER.id, (float)7.0f)).spell(water_flow);
            WeaponRegister.staff("wither_staff_terra", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.BONE}))).attribute(AttributeModifier.bonus((ResourceLocation)MoreSpellSchools.EARTH.id, (float)7.0f)).spell(obsidian_shards);
            WeaponRegister.staff("ender_dragon_staff_wind", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.AMETHYST_SHARD}))).attribute(AttributeModifier.bonus((ResourceLocation)MoreSpellSchools.AIR.id, (float)7.0f)).spell(zephyrs_speed);
        }
        entries.forEach(entry -> {
            entry.rarity = Rarity.RARE;
        });
        Weapon.register(configs, entries, (ResourceKey)Group.RPG_LOOT_KEY);
    }
}

