/*
 * Decompiled with CFR 0.152.
 */
package net.genzyuro.uniqueaccessories.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import dev.shadowsoffire.attributeslib.api.ALObjects;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.genzyuro.uniqueaccessories.config.UAClientConfigCache;
import net.genzyuro.uniqueaccessories.config.UAConfig;
import net.genzyuro.uniqueaccessories.item.UAUniqueCurioItem;
import net.genzyuro.uniqueaccessories.util.UAText;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.SlotContext;

public class SunStoneItem
extends UAUniqueCurioItem {
    private static final UUID UUID_AD = UUID.fromString("6cc6a9c1-5d5e-4e1c-8f0a-001122334401");
    private static final UUID UUID_AS = UUID.fromString("6cc6a9c1-5d5e-4e1c-8f0a-001122334402");
    private static final UUID UUID_ARMOR = UUID.fromString("6cc6a9c1-5d5e-4e1c-8f0a-001122334403");
    private static final UUID UUID_CRIT = UUID.fromString("6cc6a9c1-5d5e-4e1c-8f0a-001122334404");
    private static final UUID UUID_ARROW_D = UUID.fromString("6cc6a9c1-5d5e-4e1c-8f0a-001122334405");
    private static final UUID UUID_MINING = UUID.fromString("6cc6a9c1-5d5e-4e1c-8f0a-001122334406");

    public SunStoneItem(Item.Properties props) {
        super(props.m_41487_(1));
    }

    @Override
    protected String targetSlotId(ItemStack s) {
        return "charm";
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        if (Screen.m_96638_()) {
            String ad = UAText.n0(UAClientConfigCache.sunStoneAttackDamage);
            String as = UAText.n0(UAClientConfigCache.sunStoneAttackSpeed);
            String ar = UAText.n0(UAClientConfigCache.sunStoneArmor);
            String crit = UAText.pct0(UAClientConfigCache.sunStoneCriticalChance);
            String arr = UAText.pct0(UAClientConfigCache.sunStoneArrowDamage);
            String mine = UAText.pct0(UAClientConfigCache.sunStoneMiningSpeed);
            String healSec = String.valueOf(UAClientConfigCache.sunStoneHealSec);
            tooltip.add((Component)Component.m_237115_((String)"tooltip.uniqueaccessories.sun_stone.desc1").m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237110_((String)"tooltip.uniqueaccessories.sun_stone.desc2", (Object[])new Object[]{ad, arr, as}).m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237110_((String)"tooltip.uniqueaccessories.sun_stone.desc3", (Object[])new Object[]{ar, crit, mine}).m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237110_((String)"tooltip.uniqueaccessories.sun_stone.desc4", (Object[])new Object[]{healSec}).m_130940_(ChatFormatting.GRAY));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.uniqueaccessories.hold_shift").m_130940_(ChatFormatting.DARK_GRAY));
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext ctx, UUID uuid, ItemStack stack) {
        return ImmutableMultimap.of();
    }

    public void curioTick(SlotContext ctx, ItemStack stack) {
        int interval;
        if (!"charm".equals(ctx.identifier())) {
            return;
        }
        LivingEntity e = ctx.entity();
        if (!e.m_6084_() || e.m_5833_()) {
            return;
        }
        if (e.m_9236_().f_46443_) {
            return;
        }
        boolean isDay = e.m_9236_().m_46461_();
        double ad = (Double)UAConfig.COMMON.sunStoneAttackDamage.get();
        double as = ((Integer)UAConfig.COMMON.sunStoneAttackSpeed.get()).intValue();
        double ar = (Double)UAConfig.COMMON.sunStoneArmor.get();
        double crit = (Double)UAConfig.COMMON.sunStoneCriticalChance.get();
        double arr = (Double)UAConfig.COMMON.sunStoneArrowDamage.get();
        double mine = (Double)UAConfig.COMMON.sunStoneMiningSpeed.get();
        int healSec = (Integer)UAConfig.COMMON.sunStoneHealSec.get();
        SunStoneItem.applyOrRemove(e.m_21051_(Attributes.f_22281_), UUID_AD, isDay, ad, AttributeModifier.Operation.ADDITION);
        SunStoneItem.applyOrRemove(e.m_21051_(Attributes.f_22283_), UUID_AS, isDay, as, AttributeModifier.Operation.ADDITION);
        SunStoneItem.applyOrRemove(e.m_21051_(Attributes.f_22284_), UUID_ARMOR, isDay, ar, AttributeModifier.Operation.ADDITION);
        SunStoneItem.applyOrRemove(e.m_21051_((Attribute)ALObjects.Attributes.CRIT_CHANCE.get()), UUID_CRIT, isDay, crit, AttributeModifier.Operation.ADDITION);
        SunStoneItem.applyOrRemove(e.m_21051_((Attribute)ALObjects.Attributes.ARROW_DAMAGE.get()), UUID_ARROW_D, isDay, arr, AttributeModifier.Operation.ADDITION);
        SunStoneItem.applyOrRemove(e.m_21051_((Attribute)ALObjects.Attributes.MINING_SPEED.get()), UUID_MINING, isDay, mine, AttributeModifier.Operation.ADDITION);
        if (isDay && healSec > 0 && (interval = 20 * healSec) > 0 && e.f_19797_ % interval == 0) {
            e.m_5634_(1.0f);
        }
    }

    public void onUnequip(SlotContext ctx, ItemStack newStack, ItemStack stack) {
        LivingEntity e = ctx.entity();
        SunStoneItem.removeIfPresent(e.m_21051_(Attributes.f_22281_), UUID_AD);
        SunStoneItem.removeIfPresent(e.m_21051_(Attributes.f_22283_), UUID_AS);
        SunStoneItem.removeIfPresent(e.m_21051_(Attributes.f_22284_), UUID_ARMOR);
        Attribute critAttr = (Attribute)ALObjects.Attributes.CRIT_CHANCE.get();
        Attribute arrAttr = (Attribute)ALObjects.Attributes.ARROW_DAMAGE.get();
        Attribute mineAttr = (Attribute)ALObjects.Attributes.MINING_SPEED.get();
        if (critAttr != null) {
            SunStoneItem.removeIfPresent(e.m_21051_(critAttr), UUID_CRIT);
        }
        if (arrAttr != null) {
            SunStoneItem.removeIfPresent(e.m_21051_(arrAttr), UUID_ARROW_D);
        }
        if (mineAttr != null) {
            SunStoneItem.removeIfPresent(e.m_21051_(mineAttr), UUID_MINING);
        }
    }

    private static void applyOrRemove(AttributeInstance inst, UUID id, boolean apply, double amount, AttributeModifier.Operation op) {
        if (inst == null) {
            return;
        }
        AttributeModifier exist = inst.m_22111_(id);
        if (apply) {
            if (amount == 0.0) {
                if (exist != null) {
                    inst.m_22120_(id);
                }
                return;
            }
            if (exist == null) {
                inst.m_22118_(new AttributeModifier(id, "ua.sun_stone", amount, op));
            }
        } else if (exist != null) {
            inst.m_22120_(id);
        }
    }

    private static void removeIfPresent(AttributeInstance inst, UUID id) {
        if (inst != null && inst.m_22111_(id) != null) {
            inst.m_22120_(id);
        }
    }
}

