/*
 * Decompiled with CFR 0.152.
 */
package net.genzyuro.uniqueaccessories.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.genzyuro.uniqueaccessories.item.UAUniqueCurioItem;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeMod;
import top.theillusivec4.curios.api.SlotContext;

public class SurvivalBeltItem
extends UAUniqueCurioItem {
    private static final String TAG_LAST_ACTIVE = "ua_sv_belt_last_active";
    private static final String TAG_LAST_X = "ua_sv_belt_last_x";
    private static final String TAG_LAST_Y = "ua_sv_belt_last_y";
    private static final String TAG_LAST_Z = "ua_sv_belt_last_z";
    private static final int HEAL_RADIUS = 3;
    private static final int IDLE_TICKS_REQUIRED = 40;
    private static final int HEAL_INTERVAL = 40;

    public SurvivalBeltItem(Item.Properties props) {
        super(props.m_41487_(1));
    }

    @Override
    protected String targetSlotId(ItemStack s) {
        return "belt";
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.uniqueaccessories.survival_belt.desc1").m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.uniqueaccessories.survival_belt.desc2").m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.uniqueaccessories.survival_belt.desc3").m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.uniqueaccessories.survival_belt.desc4").m_130940_(ChatFormatting.GRAY));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.uniqueaccessories.hold_shift").m_130940_(ChatFormatting.DARK_GRAY));
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext ctx, UUID uuid, ItemStack stack) {
        if (!"belt".equals(ctx.identifier())) {
            return ImmutableMultimap.of();
        }
        return ImmutableMultimap.builder().put((Object)((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get()), (Object)new AttributeModifier(uuid, "ua.survival_belt.step_height_add", 0.5, AttributeModifier.Operation.ADDITION)).build();
    }

    public void curioTick(SlotContext ctx, ItemStack stack) {
        boolean moved;
        if (!"belt".equals(ctx.identifier())) {
            return;
        }
        LivingEntity e = ctx.entity();
        Level level = e.m_9236_();
        if (level.f_46443_) {
            return;
        }
        if (!SurvivalBeltItem.hasHeatNearby(level, e.m_20183_(), 3)) {
            SurvivalBeltItem.resetIdle(e);
            return;
        }
        long now = level.m_46467_();
        CompoundTag pd = e.getPersistentData();
        if (!pd.m_128441_(TAG_LAST_ACTIVE)) {
            pd.m_128356_(TAG_LAST_ACTIVE, now);
        }
        if (!pd.m_128441_(TAG_LAST_X)) {
            pd.m_128347_(TAG_LAST_X, e.m_20185_());
            pd.m_128347_(TAG_LAST_Y, e.m_20186_());
            pd.m_128347_(TAG_LAST_Z, e.m_20189_());
        }
        double lx = pd.m_128459_(TAG_LAST_X);
        double ly = pd.m_128459_(TAG_LAST_Y);
        double lz = pd.m_128459_(TAG_LAST_Z);
        double dx = e.m_20185_() - lx;
        double dy = e.m_20186_() - ly;
        double dz = e.m_20189_() - lz;
        boolean bl = moved = dx * dx + dz * dz > 9.0E-4 || Math.abs(dy) > 0.05;
        if (moved) {
            pd.m_128356_(TAG_LAST_ACTIVE, now);
            pd.m_128347_(TAG_LAST_X, e.m_20185_());
            pd.m_128347_(TAG_LAST_Y, e.m_20186_());
            pd.m_128347_(TAG_LAST_Z, e.m_20189_());
            return;
        }
        long idle = now - pd.m_128454_(TAG_LAST_ACTIVE);
        if (idle < 40L) {
            return;
        }
        if (now % 40L == 0L && e.m_21223_() < e.m_21233_()) {
            e.m_5634_(1.0f);
        }
    }

    private static void resetIdle(LivingEntity e) {
        CompoundTag pd = e.getPersistentData();
        pd.m_128473_(TAG_LAST_ACTIVE);
        pd.m_128473_(TAG_LAST_X);
        pd.m_128473_(TAG_LAST_Y);
        pd.m_128473_(TAG_LAST_Z);
    }

    private static boolean hasHeatNearby(Level level, BlockPos center, int r) {
        BlockPos.MutableBlockPos mp = new BlockPos.MutableBlockPos();
        int rr = r;
        for (int dx = -rr; dx <= rr; ++dx) {
            for (int dy = -rr; dy <= rr; ++dy) {
                for (int dz = -rr; dz <= rr; ++dz) {
                    mp.m_122178_(center.m_123341_() + dx, center.m_123342_() + dy, center.m_123343_() + dz);
                    BlockState st = level.m_8055_((BlockPos)mp);
                    if (!SurvivalBeltItem.isHeatBlock(st)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isHeatBlock(BlockState st) {
        if (st.m_60713_(Blocks.f_50083_) || st.m_60713_(Blocks.f_50084_)) {
            return true;
        }
        if (st.m_60713_(Blocks.f_50683_) || st.m_60713_(Blocks.f_50684_)) {
            return st.m_61138_((Property)CampfireBlock.f_51227_) && (Boolean)st.m_61143_((Property)CampfireBlock.f_51227_) != false;
        }
        return false;
    }
}

