/*
 * Decompiled with CFR 0.152.
 */
package net.genzyuro.uniqueaccessories.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class RocketThrustC2S {
    private final boolean active;
    private static final String TAG_ACTIVE_UNTIL = "ua_rs_active_until";

    public RocketThrustC2S(boolean active) {
        this.active = active;
    }

    public static void encode(RocketThrustC2S m, FriendlyByteBuf buf) {
        buf.writeBoolean(m.active);
    }

    public static RocketThrustC2S decode(FriendlyByteBuf buf) {
        return new RocketThrustC2S(buf.readBoolean());
    }

    public static void handle(RocketThrustC2S m, Supplier<NetworkEvent.Context> ctxSup) {
        NetworkEvent.Context ctx = ctxSup.get();
        ctx.enqueueWork(() -> {
            ServerPlayer p = ctx.getSender();
            if (p == null) {
                return;
            }
            ServerLevel sl = (ServerLevel)p.m_9236_();
            long now = sl.m_46467_();
            long until = m.active ? now + 4L : now;
            p.getPersistentData().m_128356_(TAG_ACTIVE_UNTIL, until);
        });
        ctx.setPacketHandled(true);
    }
}

