/*
 * Decompiled with CFR 0.152.
 */
package net.genzyuro.uniqueaccessories.system;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import net.genzyuro.uniqueaccessories.config.UAConfig;
import net.genzyuro.uniqueaccessories.registry.UAItems;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber(modid="uniqueaccessories", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SharpFishingHookEvents {
    private static final double PULL_BONUS = 0.4;
    private static final Map<UUID, LivingEntity> LAST_HOOKED = new WeakHashMap<UUID, LivingEntity>();

    private static boolean hasSharpHook(Player p) {
        return CuriosApi.getCuriosInventory((LivingEntity)p).map(inv -> !inv.findCurios(st -> st.m_150930_((Item)UAItems.SHARP_FISHING_HOOK.get())).isEmpty()).orElse(false);
    }

    @SubscribeEvent
    public static void onProjectileImpact(ProjectileImpactEvent e) {
        if (e.getEntity().m_9236_().f_46443_) {
            return;
        }
        Projectile projectile = e.getProjectile();
        if (!(projectile instanceof FishingHook)) {
            return;
        }
        FishingHook hook = (FishingHook)projectile;
        HitResult hitResult = e.getRayTraceResult();
        if (!(hitResult instanceof EntityHitResult)) {
            return;
        }
        EntityHitResult ehr = (EntityHitResult)hitResult;
        Entity entity = ehr.m_82443_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity target = (LivingEntity)entity;
        Player owner = hook.m_37168_();
        if (owner == null || !SharpFishingHookEvents.hasSharpHook(owner)) {
            return;
        }
        float dmg = (float)((Double)UAConfig.COMMON.sharpFishingHookDamage.get()).doubleValue();
        if (dmg > 0.0f) {
            target.m_6469_(owner.m_269291_().m_269075_(owner), dmg);
        }
        LAST_HOOKED.put(hook.m_20148_(), target);
    }

    @SubscribeEvent
    public static void onRightClickRod(PlayerInteractEvent.RightClickItem e) {
        Vec3 dir;
        Player p = e.getEntity();
        if (p.m_9236_().f_46443_) {
            return;
        }
        if (!(e.getItemStack().m_41720_() instanceof FishingRodItem)) {
            return;
        }
        if (!SharpFishingHookEvents.hasSharpHook(p)) {
            return;
        }
        double R = 64.0;
        List hooks = p.m_9236_().m_6443_(FishingHook.class, p.m_20191_().m_82400_(64.0), h -> h.m_37168_() == p);
        if (hooks.isEmpty()) {
            return;
        }
        FishingHook hook = (FishingHook)hooks.get(0);
        LivingEntity target = LAST_HOOKED.get(hook.m_20148_());
        if (target == null || !target.m_6084_()) {
            return;
        }
        float dmg = (float)((Double)UAConfig.COMMON.sharpFishingHookDamage.get()).doubleValue();
        if (dmg > 0.0f) {
            target.m_6469_(p.m_269291_().m_269075_(p), dmg);
        }
        if ((dir = new Vec3(p.m_20185_() - target.m_20185_(), p.m_20186_() - target.m_20186_(), p.m_20189_() - target.m_20189_())).m_82556_() > 1.0E-6) {
            Vec3 push = dir.m_82541_().m_82490_(0.4);
            Vec3 cur = target.m_20184_();
            target.m_20256_(cur.m_82520_(push.f_82479_, Math.max(push.f_82480_, 0.05), push.f_82481_));
            target.f_19812_ = true;
            target.f_19864_ = true;
        }
    }
}

