/*
 * Decompiled with CFR 0.152.
 */
package net.genzyuro.uniqueaccessories.system;

import net.genzyuro.uniqueaccessories.config.UAConfig;
import net.genzyuro.uniqueaccessories.registry.UAItems;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber(modid="uniqueaccessories", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SnowGolemDollEvents {
    @SubscribeEvent
    public static void onSnowballImpact(ProjectileImpactEvent event) {
        Projectile projectile = event.getProjectile();
        if (!(projectile instanceof Snowball)) {
            return;
        }
        Snowball snow = (Snowball)projectile;
        HitResult hitResult = event.getRayTraceResult();
        if (!(hitResult instanceof EntityHitResult)) {
            return;
        }
        EntityHitResult hit = (EntityHitResult)hitResult;
        if (snow.m_9236_().f_46443_) {
            return;
        }
        Entity owner = snow.m_19749_();
        if (!(owner instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)owner;
        boolean hasDoll = CuriosApi.getCuriosInventory((LivingEntity)living).map(inv -> !inv.findCurios(st -> st.m_150930_((Item)UAItems.SNOW_GOLEM_DOLL.get())).isEmpty()).orElse(false);
        if (!hasDoll) {
            return;
        }
        DamageSource src = ((ServerLevel)snow.m_9236_()).m_269111_().m_269390_((Entity)snow, (Entity)living);
        float dmg = ((Double)UAConfig.COMMON.snowGolemDollSnowballDamage.get()).floatValue();
        if (dmg > 0.0f) {
            hit.m_82443_().m_6469_(src, dmg);
        }
    }
}

