/*
 * Decompiled with CFR 0.152.
 */
package net.genzyuro.uniqueaccessories.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import dev.shadowsoffire.attributeslib.api.ALObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.genzyuro.uniqueaccessories.config.UAClientConfigCache;
import net.genzyuro.uniqueaccessories.config.UAConfig;
import net.genzyuro.uniqueaccessories.item.UAUniqueCurioItem;
import net.genzyuro.uniqueaccessories.util.UAText;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.SlotContext;

public class HeroEmblemItem
extends UAUniqueCurioItem {
    private static final UUID ATK_N_UUID = UUID.fromString("11111111-1111-1111-1111-111111111101");
    private static final UUID ATK_L_UUID = UUID.fromString("11111111-1111-1111-1111-111111111102");
    private static final UUID ATK_1_UUID = UUID.fromString("11111111-1111-1111-1111-111111111103");
    private static final UUID ARW_N_UUID = UUID.fromString("11111111-1111-1111-1111-111111111201");
    private static final UUID ARW_L_UUID = UUID.fromString("11111111-1111-1111-1111-111111111202");
    private static final UUID ARW_1_UUID = UUID.fromString("11111111-1111-1111-1111-111111111203");
    private static final UUID SPD_L_UUID = UUID.fromString("11111111-1111-1111-1111-111111111301");
    private static final UUID DOG_1_UUID = UUID.fromString("11111111-1111-1111-1111-111111111401");
    private static final UUID CRT_1_UUID = UUID.fromString("11111111-1111-1111-1111-111111111402");
    private static final Attribute ARROW_DAMAGE = (Attribute)ALObjects.Attributes.ARROW_DAMAGE.get();
    private static final Attribute DODGE_CHANCE = (Attribute)ALObjects.Attributes.DODGE_CHANCE.get();
    private static final Attribute CRIT_CHANCE = (Attribute)ALObjects.Attributes.CRIT_CHANCE.get();

    public HeroEmblemItem(Item.Properties props) {
        super(props.m_41487_(1));
    }

    @Override
    protected String targetSlotId(ItemStack s) {
        return "charm";
    }

    public void m_7373_(ItemStack s, @Nullable Level l, List<Component> tip, TooltipFlag f) {
        if (!Screen.m_96638_()) {
            tip.add((Component)Component.m_237115_((String)"tooltip.uniqueaccessories.hold_shift").m_130940_(ChatFormatting.DARK_GRAY));
            return;
        }
        double nAtk = UAClientConfigCache.heroEmblemAttackDamage;
        double nArr = UAClientConfigCache.heroEmblemArrowDamage;
        double lAtk = UAClientConfigCache.heroEmblemLowHpAttackDamage;
        double lArr = UAClientConfigCache.heroEmblemLowHpArrowDamage;
        double lSpd = UAClientConfigCache.heroEmblemLowHpMovementSpeed;
        double oAtk = UAClientConfigCache.heroEmblem1HpAttackDamage;
        double oArr = UAClientConfigCache.heroEmblem1HpArrowDamage;
        double oDog = UAClientConfigCache.heroEmblem1HpDodgeChance;
        double oCrt = UAClientConfigCache.heroEmblem1HpCriticalChance;
        tip.add((Component)Component.m_237110_((String)"tooltip.uniqueaccessories.hero_emblem.desc1", (Object[])new Object[]{UAText.n0(nAtk), UAText.pct0(nArr)}).m_130940_(ChatFormatting.GRAY));
        tip.add((Component)Component.m_237110_((String)"tooltip.uniqueaccessories.hero_emblem.desc2", (Object[])new Object[]{UAText.n0(lAtk), UAText.pct0(lArr), UAText.pct0(lSpd)}).m_130940_(ChatFormatting.GRAY));
        tip.add((Component)Component.m_237110_((String)"tooltip.uniqueaccessories.hero_emblem.desc3", (Object[])new Object[]{UAText.n0(oAtk), UAText.pct0(oArr), UAText.pct0(oDog), UAText.pct0(oCrt)}).m_130940_(ChatFormatting.GRAY));
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext ctx, UUID uuid, ItemStack stack) {
        return ImmutableMultimap.of();
    }

    public void curioTick(SlotContext ctx, ItemStack stack) {
        if (!"charm".equals(ctx.identifier())) {
            return;
        }
        LivingEntity e = ctx.entity();
        if (e.m_9236_().f_46443_) {
            return;
        }
        AttributeInstance atk = e.m_21051_(Attributes.f_22281_);
        AttributeInstance spd = e.m_21051_(Attributes.f_22279_);
        AttributeInstance arr = e.m_21051_(ARROW_DAMAGE);
        AttributeInstance dog = e.m_21051_(DODGE_CHANCE);
        AttributeInstance crt = e.m_21051_(CRIT_CHANCE);
        if (atk == null || spd == null || arr == null || dog == null || crt == null) {
            return;
        }
        double nAtk = (Double)UAConfig.COMMON.heroEmblemAttackDamage.get();
        double nArr = (Double)UAConfig.COMMON.heroEmblemArrowDamage.get();
        double lAtk = (Double)UAConfig.COMMON.heroEmblemLowHpAttackDamage.get();
        double lArr = (Double)UAConfig.COMMON.heroEmblemLowHpArrowDamage.get();
        double lSpd = (Double)UAConfig.COMMON.heroEmblemLowHpMovementSpeed.get();
        double oAtk = (Double)UAConfig.COMMON.heroEmblem1HpAttackDamage.get();
        double oArr = (Double)UAConfig.COMMON.heroEmblem1HpArrowDamage.get();
        double oDog = (Double)UAConfig.COMMON.heroEmblem1HpDodgeChance.get();
        double oCrt = (Double)UAConfig.COMMON.heroEmblem1HpCriticalChance.get();
        float hp = e.m_21223_();
        boolean hp1 = hp <= 1.0001f;
        boolean lowHP = hp <= 8.0001f;
        HeroEmblemItem.rm(atk, ATK_N_UUID);
        HeroEmblemItem.rm(atk, ATK_L_UUID);
        HeroEmblemItem.rm(atk, ATK_1_UUID);
        HeroEmblemItem.rm(arr, ARW_N_UUID);
        HeroEmblemItem.rm(arr, ARW_L_UUID);
        HeroEmblemItem.rm(arr, ARW_1_UUID);
        HeroEmblemItem.rm(spd, SPD_L_UUID);
        HeroEmblemItem.rm(dog, DOG_1_UUID);
        HeroEmblemItem.rm(crt, CRT_1_UUID);
        HeroEmblemItem.add(atk, ATK_N_UUID, "ua.hero_emblem.atk.normal", nAtk, AttributeModifier.Operation.ADDITION);
        HeroEmblemItem.add(arr, ARW_N_UUID, "ua.hero_emblem.arrow.normal", nArr, AttributeModifier.Operation.ADDITION);
        if (lowHP) {
            HeroEmblemItem.add(atk, ATK_L_UUID, "ua.hero_emblem.atk.low", lAtk, AttributeModifier.Operation.ADDITION);
            HeroEmblemItem.add(spd, SPD_L_UUID, "ua.hero_emblem.spd.low", lSpd, AttributeModifier.Operation.MULTIPLY_BASE);
            HeroEmblemItem.add(arr, ARW_L_UUID, "ua.hero_emblem.arrow.low", lArr, AttributeModifier.Operation.ADDITION);
        }
        if (hp1) {
            HeroEmblemItem.add(atk, ATK_1_UUID, "ua.hero_emblem.atk.hp1", oAtk, AttributeModifier.Operation.ADDITION);
            HeroEmblemItem.add(arr, ARW_1_UUID, "ua.hero_emblem.arrow.hp1", oArr, AttributeModifier.Operation.ADDITION);
            HeroEmblemItem.add(dog, DOG_1_UUID, "ua.hero_emblem.dodge.hp1", oDog, AttributeModifier.Operation.ADDITION);
            HeroEmblemItem.add(crt, CRT_1_UUID, "ua.hero_emblem.crit.hp1", oCrt, AttributeModifier.Operation.ADDITION);
            for (MobEffectInstance inst : new ArrayList(e.m_21220_())) {
                if (inst.m_19544_().m_19483_() != MobEffectCategory.HARMFUL) continue;
                e.m_21195_(inst.m_19544_());
            }
        }
    }

    public void onUnequip(SlotContext ctx, ItemStack newStack, ItemStack stack) {
        if (!"charm".equals(ctx.identifier())) {
            return;
        }
        LivingEntity e = ctx.entity();
        if (e == null || e.m_9236_().f_46443_) {
            return;
        }
        AttributeInstance atk = e.m_21051_(Attributes.f_22281_);
        AttributeInstance spd = e.m_21051_(Attributes.f_22279_);
        AttributeInstance arr = e.m_21051_(ARROW_DAMAGE);
        AttributeInstance dog = e.m_21051_(DODGE_CHANCE);
        AttributeInstance crt = e.m_21051_(CRIT_CHANCE);
        if (atk != null) {
            HeroEmblemItem.rm(atk, ATK_N_UUID);
            HeroEmblemItem.rm(atk, ATK_L_UUID);
            HeroEmblemItem.rm(atk, ATK_1_UUID);
        }
        if (spd != null) {
            HeroEmblemItem.rm(spd, SPD_L_UUID);
        }
        if (arr != null) {
            HeroEmblemItem.rm(arr, ARW_N_UUID);
            HeroEmblemItem.rm(arr, ARW_L_UUID);
            HeroEmblemItem.rm(arr, ARW_1_UUID);
        }
        if (dog != null) {
            HeroEmblemItem.rm(dog, DOG_1_UUID);
        }
        if (crt != null) {
            HeroEmblemItem.rm(crt, CRT_1_UUID);
        }
        super.onUnequip(ctx, newStack, stack);
    }

    private static void add(AttributeInstance inst, UUID id, String name, double v, AttributeModifier.Operation op) {
        if (inst.m_22111_(id) != null) {
            inst.m_22120_(id);
        }
        if (v != 0.0) {
            inst.m_22118_(new AttributeModifier(id, name, v, op));
        }
    }

    private static void rm(AttributeInstance inst, UUID id) {
        if (inst.m_22111_(id) != null) {
            inst.m_22120_(id);
        }
    }
}

