/*
 * Decompiled with CFR 0.152.
 */
package net.genzyuro.uniqueaccessories.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.genzyuro.uniqueaccessories.config.UAConfig;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public record ConfigRandomChanceCondition(String key, float def) implements LootItemCondition
{
    public static final DeferredRegister<LootItemConditionType> CONDITIONS = DeferredRegister.create((ResourceKey)Registries.f_256976_, (String)"uniqueaccessories");
    public static final RegistryObject<LootItemConditionType> TYPE = CONDITIONS.register("config_random_chance", () -> new LootItemConditionType((Serializer)new Ser()));

    public LootItemConditionType m_7940_() {
        return (LootItemConditionType)TYPE.get();
    }

    public boolean test(LootContext ctx) {
        double chance = UAConfig.getLootChanceOrDefault(this.key, this.def);
        if (chance <= 0.0) {
            return false;
        }
        if (chance >= 1.0) {
            return true;
        }
        return ctx.m_230907_().m_188500_() < chance;
    }

    public static final class Ser
    implements Serializer<ConfigRandomChanceCondition> {
        public void serialize(JsonObject json, ConfigRandomChanceCondition v, JsonSerializationContext ctx) {
            json.addProperty("key", v.key());
            json.addProperty("default", (Number)Float.valueOf(v.def()));
        }

        public ConfigRandomChanceCondition deserialize(JsonObject json, JsonDeserializationContext ctx) {
            String key = GsonHelper.m_13906_((JsonObject)json, (String)"key");
            float def = GsonHelper.m_13820_((JsonObject)json, (String)"default", (float)0.0f);
            return new ConfigRandomChanceCondition(key, def);
        }
    }
}

