/*
 * Decompiled with CFR 0.152.
 */
package net.genzyuro.uniqueaccessories.system;

import dev.shadowsoffire.attributeslib.impl.AttributeEvents;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import net.genzyuro.uniqueaccessories.registry.UAItems;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber(modid="uniqueaccessories", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BlackBeltDodgeBuffs {
    public static final UUID UUID_AD = UUID.nameUUIDFromBytes("ua:black_belt:dodge_ad".getBytes(StandardCharsets.UTF_8));
    public static final UUID UUID_MS = UUID.nameUUIDFromBytes("ua:black_belt:dodge_ms".getBytes(StandardCharsets.UTF_8));
    public static final String TAG_UNTIL = "ua_bb_dodge_until";
    public static final int DURATION_TICKS = 100;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent e) {
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        Player p = e.player;
        if (p.m_9236_().f_46443_) {
            return;
        }
        long until = p.getPersistentData().m_128454_(TAG_UNTIL);
        if (until == 0L) {
            return;
        }
        long now = ((ServerLevel)p.m_9236_()).m_46467_();
        if (now >= until) {
            AttributeInstance ms;
            AttributeInstance ad = p.m_21051_(Attributes.f_22281_);
            if (ad != null && ad.m_22111_(UUID_AD) != null) {
                ad.m_22120_(UUID_AD);
            }
            if ((ms = p.m_21051_(Attributes.f_22279_)) != null && ms.m_22111_(UUID_MS) != null) {
                ms.m_22120_(UUID_MS);
            }
            p.getPersistentData().m_128473_(TAG_UNTIL);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onMelee(LivingAttackEvent e) {
        LivingEntity target = e.getEntity();
        if (target.m_9236_().f_46443_) {
            return;
        }
        if (!BlackBeltDodgeBuffs.isBlackBeltHolder(target)) {
            return;
        }
        if (AttributeEvents.isDodging((LivingEntity)target)) {
            BlackBeltDodgeBuffs.grantBuff(target);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onProjectile(ProjectileImpactEvent e) {
        LivingEntity lv;
        EntityHitResult ehr;
        LivingEntity target;
        if (e.getProjectile().m_9236_().f_46443_) {
            return;
        }
        HitResult hitResult = e.getRayTraceResult();
        LivingEntity livingEntity = target = hitResult instanceof EntityHitResult && (hitResult = (ehr = (EntityHitResult)hitResult).m_82443_()) instanceof LivingEntity ? (lv = (LivingEntity)hitResult) : null;
        if (target == null) {
            return;
        }
        if (!BlackBeltDodgeBuffs.isBlackBeltHolder(target)) {
            return;
        }
        if (AttributeEvents.isDodging(target)) {
            BlackBeltDodgeBuffs.grantBuff(target);
        }
    }

    private static boolean isBlackBeltHolder(LivingEntity e) {
        if (!(e instanceof Player)) {
            return false;
        }
        Player p = (Player)e;
        return CuriosApi.getCuriosInventory((LivingEntity)p).map(inv -> !inv.findCurios(st -> st.m_150930_((Item)UAItems.BLACK_BELT.get())).isEmpty()).orElse(false);
    }

    private static void grantBuff(LivingEntity e) {
        Level level = e.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)level;
        long now = sl.m_46467_();
        long until = now + 100L;
        e.getPersistentData().m_128356_(TAG_UNTIL, until);
        BlackBeltDodgeBuffs.setTransient(e.m_21051_(Attributes.f_22281_), UUID_AD, "ua.black_belt.dodge.ad", 4.0, AttributeModifier.Operation.ADDITION);
        BlackBeltDodgeBuffs.setTransient(e.m_21051_(Attributes.f_22279_), UUID_MS, "ua.black_belt.dodge.ms", 0.2, AttributeModifier.Operation.MULTIPLY_BASE);
    }

    private static void setTransient(AttributeInstance inst, UUID id, String name, double val, AttributeModifier.Operation op) {
        if (inst == null) {
            return;
        }
        if (inst.m_22111_(id) != null) {
            inst.m_22120_(id);
        }
        inst.m_22118_(new AttributeModifier(id, name, val, op));
    }
}

