/*
 * Decompiled with CFR 0.152.
 */
package net.genzyuro.uniqueaccessories.system;

import java.util.UUID;
import net.genzyuro.uniqueaccessories.registry.UAItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber(modid="uniqueaccessories", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EnderLensEvents {
    private static final int FOCUS_TICKS = 40;
    private static final int COOLDOWN_TICK = 1;
    private static final double MAX_DIST = 320.0;
    private static final String TAG_FOCUS_START = "ua_enderlens_focus_start";
    private static final String TAG_FOCUS_UUID = "ua_enderlens_focus_uuid";
    private static final String TAG_COOLDOWN_UNTIL = "ua_enderlens_cd_until";

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent e) {
        UUID prev;
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        Player p = e.player;
        Level lvl = p.m_9236_();
        if (lvl.f_46443_ || !(lvl instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)lvl;
        if (!p.m_6084_() || p.m_5833_()) {
            return;
        }
        boolean equipped = CuriosApi.getCuriosInventory((LivingEntity)p).map(inv -> !inv.findCurios(st -> st.m_150930_((Item)UAItems.ENDER_LENS.get())).isEmpty()).orElse(false);
        if (!equipped) {
            EnderLensEvents.resetFocus(p);
            return;
        }
        long now = sl.m_46467_();
        if (now < p.getPersistentData().m_128454_(TAG_COOLDOWN_UNTIL)) {
            EnderLensEvents.resetFocus(p);
            return;
        }
        if (!p.m_150108_()) {
            EnderLensEvents.resetFocus(p);
            return;
        }
        LivingEntity looking = EnderLensEvents.pickLivingEntity(p, 320.0);
        if (looking == null) {
            EnderLensEvents.resetFocus(p);
            return;
        }
        CompoundTag pd = p.getPersistentData();
        UUID uUID = prev = pd.m_128403_(TAG_FOCUS_UUID) ? pd.m_128342_(TAG_FOCUS_UUID) : null;
        if (prev == null || !prev.equals(looking.m_20148_())) {
            pd.m_128362_(TAG_FOCUS_UUID, looking.m_20148_());
            pd.m_128356_(TAG_FOCUS_START, now);
            return;
        }
        long started = pd.m_128454_(TAG_FOCUS_START);
        if (now - started >= 40L) {
            if (EnderLensEvents.teleportToEntitySafe(sl, p, looking)) {
                pd.m_128356_(TAG_COOLDOWN_UNTIL, now + 1L);
            }
            EnderLensEvents.resetFocus(p);
        }
    }

    private static void resetFocus(Player p) {
        CompoundTag pd = p.getPersistentData();
        pd.m_128473_(TAG_FOCUS_START);
        if (pd.m_128441_(TAG_FOCUS_UUID)) {
            pd.m_128473_(TAG_FOCUS_UUID);
        }
    }

    private static LivingEntity pickLivingEntity(Player p, double maxDist) {
        Vec3 eyePos = p.m_20299_(1.0f);
        Vec3 look = p.m_20154_();
        Vec3 end = eyePos.m_82549_(look.m_82490_(maxDist));
        BlockHitResult blockHit = p.m_9236_().m_45547_(new ClipContext(eyePos, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)p));
        double limit = maxDist;
        if (blockHit.m_6662_() != HitResult.Type.MISS) {
            limit = eyePos.m_82554_(blockHit.m_82450_());
        }
        AABB box = p.m_20191_().m_82369_(look.m_82490_(limit)).m_82400_(1.0);
        EntityHitResult ehr = ProjectileUtil.m_37304_((Level)p.m_9236_(), (Entity)p, (Vec3)eyePos, (Vec3)eyePos.m_82549_(look.m_82490_(limit)), (AABB)box, e -> e instanceof LivingEntity && e.m_6087_() && e.m_6084_() && e != p);
        if (ehr == null) {
            return null;
        }
        double entDist = eyePos.m_82554_(ehr.m_82450_());
        if (entDist > limit) {
            return null;
        }
        return (LivingEntity)ehr.m_82443_();
    }

    private static boolean teleportToEntitySafe(ServerLevel sl, Player p, LivingEntity target) {
        Vec3 from = p.m_20182_();
        BlockPos base = target.m_20183_();
        BlockPos best = null;
        int range = 6;
        for (int dy = 0; dy <= range; ++dy) {
            for (int sign = 0; sign <= 1; ++sign) {
                int yOff = sign == 0 ? dy : -dy;
                BlockPos pos = new BlockPos(base.m_123341_(), base.m_123342_() + yOff, base.m_123343_());
                if (!EnderLensEvents.isSafeStandPos(sl, pos, (Entity)p)) continue;
                best = pos;
                break;
            }
            if (best != null) break;
        }
        if (best == null) {
            int[][] offsets;
            block2: for (int[] off : offsets = new int[][]{{1, 0}, {-1, 0}, {0, 1}, {0, -1}, {1, 1}, {-1, 1}, {1, -1}, {-1, -1}}) {
                BlockPos side = base.m_7918_(off[0], 0, off[1]);
                for (int dy = 0; dy <= range; ++dy) {
                    for (int sign = 0; sign <= 1; ++sign) {
                        int yOff = sign == 0 ? dy : -dy;
                        BlockPos pos = new BlockPos(side.m_123341_(), side.m_123342_() + yOff, side.m_123343_());
                        if (!EnderLensEvents.isSafeStandPos(sl, pos, (Entity)p)) continue;
                        best = pos;
                        break block2;
                    }
                }
            }
        }
        if (best == null) {
            return false;
        }
        double px = (double)best.m_123341_() + 0.5;
        double py = best.m_123342_();
        double pz = (double)best.m_123343_() + 0.5;
        Vec3 to = new Vec3((double)best.m_123341_() + 0.5, (double)best.m_123342_(), (double)best.m_123343_() + 0.5);
        if (!(p instanceof ServerPlayer)) {
            return false;
        }
        ServerPlayer sp = (ServerPlayer)p;
        EnderLensEvents.playEndermanFX(sl, from);
        sp.m_8999_(sl, px, py, pz, sp.m_146908_(), sp.m_146909_());
        EnderLensEvents.playEndermanFX(sl, to);
        sp.f_19789_ = 0.0f;
        return true;
    }

    private static boolean isSafeStandPos(ServerLevel sl, BlockPos feet, Entity ref) {
        if (sl.m_8055_(feet.m_7495_()).m_60795_()) {
            return false;
        }
        return sl.m_45786_(ref);
    }

    private static void playEndermanFX(ServerLevel level, Vec3 pos) {
        level.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
        level.m_8767_((ParticleOptions)ParticleTypes.f_123760_, pos.f_82479_, pos.f_82480_ + 1.0, pos.f_82481_, 64, 0.5, 0.5, 0.5, 0.0);
        level.m_8767_((ParticleOptions)ParticleTypes.f_123789_, pos.f_82479_, pos.f_82480_ + 1.0, pos.f_82481_, 16, 0.4, 0.3, 0.4, 0.0);
    }
}

