/*
 * Decompiled with CFR 0.152.
 */
package net.genzyuro.uniqueaccessories.system;

import net.genzyuro.uniqueaccessories.config.UAConfig;
import net.genzyuro.uniqueaccessories.registry.UAItems;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber(modid="uniqueaccessories", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class RocketShoesEvents {
    private static final String TAG_REMAIN = "ua_rs_remain";
    private static final String TAG_CONT = "ua_rs_continuous";
    private static final String TAG_BONUS = "ua_rs_bonus";
    private static final String TAG_ACTIVE_UNTIL = "ua_rs_active_until";
    private static final String TAG_SEEN_RELEASE = "ua_rs_seen_release";
    private static final double BASE_UP = 0.17;
    private static final double BONUS_STEP = 0.004;
    private static final double BONUS_MAX = 0.45;
    private static final double VY_CAP = 0.75;

    private static boolean hasRocketShoes(Player p) {
        return CuriosApi.getCuriosInventory((LivingEntity)p).map(inv -> !inv.findCurios(st -> st.m_150930_((Item)UAItems.ROCKET_SHOES.get())).isEmpty()).orElse(false);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent e) {
        boolean canThrust;
        boolean pressed;
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        Player p = e.player;
        if (p.m_9236_().f_46443_) {
            return;
        }
        if (!RocketShoesEvents.hasRocketShoes(p)) {
            RocketShoesEvents.resetIfNeeded(p, false);
            return;
        }
        ServerLevel sl = (ServerLevel)p.m_9236_();
        long now = sl.m_46467_();
        int maxTicks = (Integer)UAConfig.COMMON.rocketShoesMaxTicks.get();
        if (maxTicks < 1) {
            maxTicks = 1;
        }
        if (maxTicks > 400) {
            maxTicks = 400;
        }
        CompoundTag nbt = p.getPersistentData();
        int remain = nbt.m_128451_(TAG_REMAIN);
        int cont = nbt.m_128451_(TAG_CONT);
        double bonus = nbt.m_128459_(TAG_BONUS);
        long activeUntil = nbt.m_128454_(TAG_ACTIVE_UNTIL);
        boolean seenRelease = nbt.m_128471_(TAG_SEEN_RELEASE);
        boolean bl = pressed = now <= activeUntil;
        if (p.m_20096_()) {
            remain = maxTicks;
            cont = 0;
            bonus = 0.0;
            seenRelease = false;
            nbt.m_128405_(TAG_REMAIN, remain);
            nbt.m_128405_(TAG_CONT, cont);
            nbt.m_128347_(TAG_BONUS, bonus);
            nbt.m_128379_(TAG_SEEN_RELEASE, seenRelease);
            return;
        }
        if (!pressed) {
            if (!seenRelease) {
                seenRelease = true;
                nbt.m_128379_(TAG_SEEN_RELEASE, true);
            }
            if (cont > 0 || bonus > 0.0) {
                cont = 0;
                bonus = 0.0;
                nbt.m_128405_(TAG_CONT, cont);
                nbt.m_128347_(TAG_BONUS, bonus);
            }
            return;
        }
        boolean bl2 = canThrust = pressed && seenRelease && remain > 0 && p.m_6084_() && !p.m_5833_() && !p.m_20072_() && !p.m_20077_() && !p.m_21255_() && !p.m_20159_();
        if (!canThrust) {
            return;
        }
        ++cont;
        bonus = Math.min(0.45, bonus + 0.004);
        sl.m_6263_(null, p.m_20185_(), p.m_20186_(), p.m_20189_(), SoundEvents.f_11874_, SoundSource.PLAYERS, 0.4f, 1.1f);
        Vec3 v = p.m_20184_();
        double targetVy = Math.min(v.f_82480_ + (0.17 + bonus), 0.75);
        double newVy = Mth.m_14139_((double)0.45, (double)v.f_82480_, (double)targetVy);
        double addY = newVy - v.f_82480_;
        if (addY > 1.0E-6) {
            p.m_20256_(v.m_82520_(0.0, addY, 0.0));
        }
        p.f_19812_ = true;
        p.f_19864_ = true;
        p.f_19789_ = cont >= 20 && (now & 1L) == 0L ? Math.max(0.0f, p.f_19789_ - 1.0f) : Math.max(0.0f, p.f_19789_ - 0.2f);
        nbt.m_128405_(TAG_REMAIN, --remain);
        nbt.m_128405_(TAG_CONT, cont);
        nbt.m_128347_(TAG_BONUS, bonus);
        double baseX = p.m_20185_();
        double baseY = p.m_20186_() - 0.15;
        double baseZ = p.m_20189_();
        Vec3 look = p.m_20252_(1.0f);
        Vec3 fwd = new Vec3(look.f_82479_, 0.0, look.f_82481_);
        if (fwd.m_82556_() < 1.0E-6) {
            fwd = new Vec3(0.0, 0.0, 1.0);
        }
        fwd = fwd.m_82541_();
        Vec3 right = new Vec3(-fwd.f_82481_, 0.0, fwd.f_82479_);
        double width = 0.2;
        Vec3 leftPos = new Vec3(baseX - right.f_82479_ * width, baseY, baseZ - right.f_82481_ * width);
        Vec3 rightPos = new Vec3(baseX + right.f_82479_ * width, baseY, baseZ + right.f_82481_ * width);
        double downSpeed = 0.07;
        double jitter = 0.001;
        sl.m_8767_((ParticleOptions)ParticleTypes.f_123744_, leftPos.f_82479_, leftPos.f_82480_, leftPos.f_82481_, 2, jitter, 0.01, jitter, -downSpeed);
        sl.m_8767_((ParticleOptions)ParticleTypes.f_123762_, leftPos.f_82479_, leftPos.f_82480_, leftPos.f_82481_, 1, jitter, 0.01, jitter, -downSpeed * 0.6);
        sl.m_8767_((ParticleOptions)ParticleTypes.f_123744_, rightPos.f_82479_, rightPos.f_82480_, rightPos.f_82481_, 2, jitter, 0.01, jitter, -downSpeed);
        sl.m_8767_((ParticleOptions)ParticleTypes.f_123762_, rightPos.f_82479_, rightPos.f_82480_, rightPos.f_82481_, 1, jitter, 0.01, jitter, -downSpeed * 0.6);
    }

    private static void resetIfNeeded(Player p, boolean full) {
        CompoundTag nbt = p.getPersistentData();
        int maxTicks = (Integer)UAConfig.COMMON.rocketShoesMaxTicks.get();
        if (full) {
            nbt.m_128405_(TAG_REMAIN, maxTicks);
        }
        nbt.m_128405_(TAG_CONT, 0);
        nbt.m_128347_(TAG_BONUS, 0.0);
    }
}

