/*
 * Decompiled with CFR 0.152.
 */
package net.genzyuro.uniqueaccessories.system;

import net.genzyuro.uniqueaccessories.registry.UAItems;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber(modid="uniqueaccessories", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class WaistWarmerEvents {
    private static final int BUFF_TICKS = 2400;
    private static final float HEAL_AMOUNT = 10.0f;

    private static boolean hasWaistWarmer(LivingEntity e) {
        return CuriosApi.getCuriosInventory((LivingEntity)e).map(inv -> !inv.findCurios(st -> st.m_150930_((Item)UAItems.WAIST_WARMER.get())).isEmpty()).orElse(false);
    }

    @SubscribeEvent
    public static void onFreezeDamage(LivingHurtEvent e) {
        LivingEntity le = e.getEntity();
        if (le.m_9236_().f_46443_) {
            return;
        }
        if (!WaistWarmerEvents.hasWaistWarmer(le)) {
            return;
        }
        DamageSource src = e.getSource();
        if (src.m_276093_(DamageTypes.f_268444_)) {
            e.setCanceled(true);
            le.m_146917_(0);
        }
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent e) {
        LivingEntity le = e.getEntity();
        if (le.m_9236_().f_46443_) {
            return;
        }
        if (!WaistWarmerEvents.hasWaistWarmer(le)) {
            return;
        }
        if (le.m_146888_() > 0) {
            le.m_146917_(0);
        }
    }

    @SubscribeEvent
    public static void onWake(PlayerWakeUpEvent e) {
        Player p = e.getEntity();
        if (p.m_9236_().f_46443_) {
            return;
        }
        if (!WaistWarmerEvents.hasWaistWarmer((LivingEntity)p)) {
            return;
        }
        ServerLevel sl = (ServerLevel)p.m_9236_();
        long dayTime = sl.m_46468_() % 24000L;
        if (dayTime > 3000L) {
            return;
        }
        p.m_5634_(10.0f);
        p.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 2400, 0));
        p.m_7292_(new MobEffectInstance(MobEffects.f_19598_, 2400, 0));
        p.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 2400, 0));
    }
}

