/*
 * Decompiled with CFR 0.152.
 */
package net.genzyuro.uniqueaccessories.config;

import java.util.HashMap;
import java.util.Map;
import net.genzyuro.uniqueaccessories.loot.LootChanceKeys;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public final class UAConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;
    private static boolean registered;

    public static void register() {
        if (registered) {
            return;
        }
        registered = true;
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)COMMON_SPEC, "uniqueaccessories-common.toml");
    }

    public static double getLootChanceOrDefault(String key, double def) {
        ForgeConfigSpec.DoubleValue v = UAConfig.COMMON.lootChances.get(key);
        return v != null ? (Double)v.get() : def;
    }

    private UAConfig() {
    }

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON = (Common)pair.getLeft();
        COMMON_SPEC = (ForgeConfigSpec)pair.getRight();
        registered = false;
    }

    public static final class Common {
        public final ForgeConfigSpec.DoubleValue goldenEggChance;
        public final ForgeConfigSpec.DoubleValue royalHoneycombChance;
        public final Map<String, ForgeConfigSpec.DoubleValue> lootChances = new HashMap<String, ForgeConfigSpec.DoubleValue>();
        public final ForgeConfigSpec.IntValue rocketShoesMaxTicks;
        public final ForgeConfigSpec.DoubleValue amplifierStoneRadius;
        public final ForgeConfigSpec.DoubleValue amplifierStoneDamage;
        public final ForgeConfigSpec.DoubleValue magickQuiverArrowDamage;
        public final ForgeConfigSpec.DoubleValue magickQuiverArrowVelocity;
        public final ForgeConfigSpec.DoubleValue goldenEggDamage;
        public final ForgeConfigSpec.DoubleValue toolBeltBlockReach;
        public final ForgeConfigSpec.DoubleValue smallPropulsionMultiplier;
        public final ForgeConfigSpec.DoubleValue sunStoneAttackDamage;
        public final ForgeConfigSpec.DoubleValue sunStoneArmor;
        public final ForgeConfigSpec.DoubleValue sunStoneArrowDamage;
        public final ForgeConfigSpec.DoubleValue sunStoneCriticalChance;
        public final ForgeConfigSpec.DoubleValue sunStoneMiningSpeed;
        public final ForgeConfigSpec.IntValue sunStoneAttackSpeed;
        public final ForgeConfigSpec.IntValue sunStoneHealSec;
        public final ForgeConfigSpec.DoubleValue moonStoneAttackDamage;
        public final ForgeConfigSpec.DoubleValue moonStoneArmor;
        public final ForgeConfigSpec.DoubleValue moonStoneArrowDamage;
        public final ForgeConfigSpec.DoubleValue moonStoneCriticalChance;
        public final ForgeConfigSpec.DoubleValue moonStoneMiningSpeed;
        public final ForgeConfigSpec.IntValue moonStoneAttackSpeed;
        public final ForgeConfigSpec.IntValue moonStoneHealSec;
        public final ForgeConfigSpec.DoubleValue heroEmblemAttackDamage;
        public final ForgeConfigSpec.DoubleValue heroEmblemArrowDamage;
        public final ForgeConfigSpec.DoubleValue heroEmblemLowHpAttackDamage;
        public final ForgeConfigSpec.DoubleValue heroEmblemLowHpArrowDamage;
        public final ForgeConfigSpec.DoubleValue heroEmblemLowHpMovementSpeed;
        public final ForgeConfigSpec.DoubleValue heroEmblem1HpAttackDamage;
        public final ForgeConfigSpec.DoubleValue heroEmblem1HpArrowDamage;
        public final ForgeConfigSpec.DoubleValue heroEmblem1HpDodgeChance;
        public final ForgeConfigSpec.DoubleValue heroEmblem1HpCriticalChance;
        public final ForgeConfigSpec.DoubleValue burningSoulLevelCost;
        public final ForgeConfigSpec.DoubleValue soulGemHeal;
        public final ForgeConfigSpec.DoubleValue devilsEyeballCriticalChance;
        public final ForgeConfigSpec.DoubleValue devilsEyeballCriticalDamage;
        public final ForgeConfigSpec.DoubleValue starvedWolfSkullHeal;
        public final ForgeConfigSpec.DoubleValue starvedWolfSkullMovementSpeed;
        public final ForgeConfigSpec.DoubleValue starvedWolfSkullAttackDamage;
        public final ForgeConfigSpec.DoubleValue witheredHeartMaxHp;
        public final ForgeConfigSpec.DoubleValue fossilSharkToothPenetration;
        public final ForgeConfigSpec.DoubleValue sharpFishingHookDamage;
        public final ForgeConfigSpec.DoubleValue ancientChiselMining;
        public final ForgeConfigSpec.DoubleValue cursedDollHeadEffectRadius;
        public final ForgeConfigSpec.DoubleValue snowGolemDollSnowballDamage;
        public final ForgeConfigSpec.DoubleValue championshipBeltUnarmedAttackDamage;
        public final ForgeConfigSpec.DoubleValue championshipBeltUnarmedAttackSpeed;
        public final ForgeConfigSpec.DoubleValue championshipBeltArmor;
        public final ForgeConfigSpec.DoubleValue championshipBeltMovementSpeed;
        public final ForgeConfigSpec.DoubleValue championshipBeltDodgeChance;
        public final ForgeConfigSpec.DoubleValue championshipBeltKnockbackResistance;
        public final ForgeConfigSpec.DoubleValue blackBeltDodgeChance;
        public final ForgeConfigSpec.DoubleValue silverCatTailSprintSpeed;
        public final ForgeConfigSpec.DoubleValue tabiWalkSpeed;
        public final ForgeConfigSpec.DoubleValue ankletOfFortuneDebuffNegateChance;
        public final ForgeConfigSpec.DoubleValue durableSpringMovementSpeed;

        Common(ForgeConfigSpec.Builder b) {
            b.push("loot");
            this.goldenEggChance = b.defineInRange("goldenEggChance", 0.002, 0.0, 1.0);
            this.royalHoneycombChance = b.defineInRange("royalHoneycombChance", 0.01, 0.0, 1.0);
            b.push("chances");
            for (LootChanceKeys.Entry e : LootChanceKeys.entries()) {
                String pathKey = e.key().replace('.', '_');
                this.lootChances.put(e.key(), b.comment("chance for " + e.key()).defineInRange(pathKey, e.def(), 0.0, 1.0));
            }
            b.pop();
            b.pop().push("charm");
            this.amplifierStoneRadius = b.defineInRange("amplifierStoneRadius", 24.0, 0.0, 512.0);
            this.amplifierStoneDamage = b.defineInRange("amplifierStoneDamage", 2.0, 0.0, 10000.0);
            this.ancientChiselMining = b.defineInRange("ancientChiselMining", 0.5, -10.0, 100.0);
            this.burningSoulLevelCost = b.defineInRange("burningSoulLevelCost", 1.0, 0.0, 100.0);
            this.cursedDollHeadEffectRadius = b.defineInRange("cursedDollHeadEffectRadius", 48.0, 0.0, 512.0);
            this.devilsEyeballCriticalChance = b.defineInRange("devilsEyeballCriticalChance", 0.2, 0.0, 1.0);
            this.devilsEyeballCriticalDamage = b.defineInRange("devilsEyeballCriticalDamage", 0.2, -10.0, 100.0);
            this.fossilSharkToothPenetration = b.defineInRange("fossilSharkToothPenetration", 5.0, -1000.0, 1000.0);
            this.goldenEggDamage = b.defineInRange("goldenEggDamage", 8.0, 0.0, 10000.0);
            this.heroEmblemAttackDamage = b.defineInRange("heroEmblemAttackDamage", 2.0, -1000.0, 10000.0);
            this.heroEmblemArrowDamage = b.defineInRange("heroEmblemArrowDamage", 0.1, -10.0, 100.0);
            this.heroEmblemLowHpAttackDamage = b.defineInRange("heroEmblemLowHpAttackDamage", 4.0, -1000.0, 10000.0);
            this.heroEmblemLowHpArrowDamage = b.defineInRange("heroEmblemLowHpArrowDamage", 0.2, -10.0, 100.0);
            this.heroEmblemLowHpMovementSpeed = b.defineInRange("heroEmblemLowHpMovementSpeed", 0.2, -10.0, 100.0);
            this.heroEmblem1HpAttackDamage = b.defineInRange("heroEmblem1HpAttackDamage", 6.0, -1000.0, 10000.0);
            this.heroEmblem1HpArrowDamage = b.defineInRange("heroEmblem1HpArrowDamage", 0.3, -10.0, 100.0);
            this.heroEmblem1HpDodgeChance = b.defineInRange("heroEmblem1HpDodgeChance", 0.2, 0.0, 1.0);
            this.heroEmblem1HpCriticalChance = b.defineInRange("heroEmblem1HpCriticalChance", 0.2, 0.0, 1.0);
            this.magickQuiverArrowDamage = b.defineInRange("magickQuiverArrowDamage", 0.3, -10.0, 100.0);
            this.magickQuiverArrowVelocity = b.defineInRange("magickQuiverArrowVelocity", 0.2, -10.0, 100.0);
            this.moonStoneAttackDamage = b.defineInRange("moonStoneAttackDamage", 4.0, -1000.0, 1000.0);
            this.moonStoneArmor = b.defineInRange("moonStoneArmor", 4.0, -1000.0, 1000.0);
            this.moonStoneArrowDamage = b.defineInRange("moonStoneArrowDamage", 0.2, -10.0, 100.0);
            this.moonStoneCriticalChance = b.defineInRange("moonStoneCriticalChance", 0.2, 0.0, 1.0);
            this.moonStoneMiningSpeed = b.defineInRange("moonStoneMiningSpeed", 0.25, -10.0, 100.0);
            this.moonStoneAttackSpeed = b.defineInRange("moonStoneAttackSpeed", 1, 0, 10000);
            this.moonStoneHealSec = b.defineInRange("moonStoneHealSec", 6, 0, 600);
            this.sharpFishingHookDamage = b.defineInRange("sharpFishingHookDamage", 2.0, -1000.0, 1000.0);
            this.smallPropulsionMultiplier = b.defineInRange("smallPropulsionMultiplier", 1.3, 0.0, 100.0);
            this.snowGolemDollSnowballDamage = b.defineInRange("snowGolemDollSnowballDamage", 2.0, -1000.0, 10000.0);
            this.soulGemHeal = b.defineInRange("soulGemHeal", 2.0, 0.0, 1000.0);
            this.starvedWolfSkullHeal = b.defineInRange("starvedWolfSkullHeal", 1.0, 0.0, 1000.0);
            this.starvedWolfSkullMovementSpeed = b.defineInRange("starvedWolfSkullMovementSpeed", 0.3, -10.0, 100.0);
            this.starvedWolfSkullAttackDamage = b.defineInRange("starvedWolfSkullAttackDamage", 6.0, -1000.0, 10000.0);
            this.sunStoneAttackDamage = b.defineInRange("sunStoneAttackDamage", 4.0, -1000.0, 10000.0);
            this.sunStoneArmor = b.defineInRange("sunStoneArmor", 4.0, -1000.0, 10000.0);
            this.sunStoneArrowDamage = b.defineInRange("sunStoneArrowDamage", 0.2, -10.0, 100.0);
            this.sunStoneCriticalChance = b.defineInRange("sunStoneCriticalChance", 0.2, 0.0, 1.0);
            this.sunStoneMiningSpeed = b.defineInRange("sunStoneMiningSpeed", 0.25, -10.0, 100.0);
            this.sunStoneAttackSpeed = b.defineInRange("sunStoneAttackSpeed", 1, 0, 10000);
            this.sunStoneHealSec = b.defineInRange("sunStoneHealSec", 6, 0, 600);
            this.witheredHeartMaxHp = b.defineInRange("witheredHeartMaxHp", 1.0, -1000.0, 1000.0);
            b.pop().push("belt");
            this.blackBeltDodgeChance = b.defineInRange("blackBeltDodgeChance", 0.15, 0.0, 1.0);
            this.championshipBeltUnarmedAttackDamage = b.defineInRange("championshipBeltUnarmedAttackDamage", 6.0, -1000.0, 10000.0);
            this.championshipBeltUnarmedAttackSpeed = b.defineInRange("championshipBeltUnarmedAttackSpeed", 2.0, -10.0, 1000.0);
            this.championshipBeltArmor = b.defineInRange("championshipBeltArmor", 4.0, -1000.0, 10000.0);
            this.championshipBeltMovementSpeed = b.defineInRange("championshipBeltMovementSpeed", 0.05, -10.0, 100.0);
            this.championshipBeltDodgeChance = b.defineInRange("championshipBeltDodgeChance", 0.05, 0.0, 1.0);
            this.championshipBeltKnockbackResistance = b.defineInRange("championshipBeltKnockbackResistance", 0.1, 0.0, 1.0);
            this.silverCatTailSprintSpeed = b.defineInRange("silverCatTailSprintSpeed", 0.1, 0.0, 100.0);
            this.toolBeltBlockReach = b.defineInRange("toolBeltBlockReach", 2.0, -10.0, 1000.0);
            b.pop().push("feet");
            this.ankletOfFortuneDebuffNegateChance = b.defineInRange("ankletOfFortuneDebuffNegateChance", 0.5, 0.0, 1.0);
            this.durableSpringMovementSpeed = b.defineInRange("durableSpringMovementSpeed", 0.05, -10.0, 100.0);
            this.rocketShoesMaxTicks = b.defineInRange("rocketShoesMaxTicks", 40, 1, 12000);
            this.tabiWalkSpeed = b.defineInRange("tabiWalkSpeed", 0.1, -10.0, 100.0);
            b.pop();
        }
    }

    public static final class BaseDefs {
        public static final double GOLDEN_EGG_CHANCE = 0.002;
        public static final double ROYAL_HONEYCOMB_CHANCE = 0.01;
        public static final double AMPLIFIER_STONE_RADIUS = 24.0;
        public static final double AMPLIFIER_STONE_DAMAGE = 2.0;
        public static final double MAGICK_QUIVER_ARROW_DAMAGE = 0.3;
        public static final double MAGICK_QUIVER_ARROW_VELOCITY = 0.2;
        public static final double TOOL_BELT_BLOCK_REACH = 2.0;
        public static final double SMALL_PROPULSION_MULTIPLIER = 1.3;
        public static final double SUN_STONE_ATTACK_DAMAGE = 4.0;
        public static final double SUN_STONE_ARMOR = 4.0;
        public static final double SUN_STONE_ARROW_DAMAGE = 0.2;
        public static final double SUN_STONE_CRITICAL_CHANCE = 0.2;
        public static final double SUN_STONE_MINING_SPEED = 0.25;
        public static final int SUN_STONE_ATTACK_SPEED = 1;
        public static final int SUN_STONE_HEAL_SEC = 6;
        public static final double MOON_STONE_ATTACK_DAMAGE = 4.0;
        public static final double MOON_STONE_ARMOR = 4.0;
        public static final double MOON_STONE_ARROW_DAMAGE = 0.2;
        public static final double MOON_STONE_CRITICAL_CHANCE = 0.2;
        public static final double MOON_STONE_MINING_SPEED = 0.25;
        public static final int MOON_STONE_ATTACK_SPEED = 1;
        public static final int MOON_STONE_HEAL_SEC = 6;
        public static final double HERO_EMBLEM_ATTACK_DAMAGE = 2.0;
        public static final double HERO_EMBLEM_ARROW_DAMAGE = 0.1;
        public static final double HERO_EMBLEM_LOW_HP_ATTACK_DAMAGE = 4.0;
        public static final double HERO_EMBLEM_LOW_HP_ARROW_DAMAGE = 0.2;
        public static final double HERO_EMBLEM_LOW_HP_MOVEMENT_SPEED = 0.2;
        public static final double HERO_EMBLEM_1_HP_ATTACK_DAMAGE = 6.0;
        public static final double HERO_EMBLEM_1_HP_ARROW_DAMAGE = 0.3;
        public static final double HERO_EMBLEM_1_HP_DODGE_Chance = 0.2;
        public static final double HERO_EMBLEM_1_HP_CRITICAL_Chance = 0.2;
        public static final int BURNING_SOUL_LEVEL_COST = 1;
        public static final double SOUL_GEM_HEAL = 2.0;
        public static final double DEVILS_EYEBALL_CRITICAL_CHANCE = 0.2;
        public static final double DEVILS_EYEBALL_CRITICAL_DAMAGE = 0.2;
        public static final double STARVED_WOLF_SKULL_HEAL = 1.0;
        public static final double STARVED_WOLF_SKULL_MOVEMENT_SPEED = 0.3;
        public static final double STARVED_WOLF_SKULL_ATTACK_DAMAGE = 6.0;
        public static final int WITHERED_HEART_MAX_HP = 1;
        public static final double FOSSIL_SHARK_TOOTH_PENETRATION = 5.0;
        public static final double SHARP_FISHING_HOOK_DAMAGE = 2.0;
        public static final double ANCIENT_CHISEL_MINING = 0.5;
        public static final double CURSED_DOLL_HEAD_EFFECT_RADIUS = 48.0;
        public static final double SNOW_GOLEM_DOLL_SNOWBALL_DAMAGE = 2.0;
        public static final double CHAMPIONSHIP_BELT_UNARMED_ATTACK_DAMAGE = 6.0;
        public static final double CHAMPIONSHIP_BELT_UNARMED_ATTACK_SPEED = 2.0;
        public static final double CHAMPIONSHIP_BELT_ARMOR = 4.0;
        public static final double CHAMPIONSHIP_BELT_MOVEMENT_SPEED = 0.05;
        public static final double CHAMPIONSHIP_BELT_DODGE_CHANCE = 0.05;
        public static final double CHAMPIONSHIP_BELT_KNOCKBACK_RESISTANCE = 0.1;
        public static final double BLACK_BELT_DODGE_CHANCE = 0.15;
        public static final double SILVER_CAT_TAIL_SPRINT_SPEED = 0.1;
        public static final double TABI_WALK_SPEED = 0.1;
        public static final double ANKLET_OF_FORTUNE_DEBUFF_NEGATE_CHANCE = 0.5;
        public static final double DURABLE_SPRING_MOVEMENT_SPEED = 0.05;
    }
}

