/*
 * Decompiled with CFR 0.152.
 */
package net.genzyuro.uniqueaccessories.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.genzyuro.uniqueaccessories.config.UAClientConfigCache;
import net.genzyuro.uniqueaccessories.config.UAConfig;
import net.genzyuro.uniqueaccessories.item.UAUniqueCurioItem;
import net.genzyuro.uniqueaccessories.util.UAText;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.curios.api.SlotContext;

public class ChampionshipBeltItem
extends UAUniqueCurioItem {
    private static final UUID ARMOR_UUID = UUID.fromString("5a0a9c0a-6ef8-426b-8d08-4f1e6a8d1111");
    private static final UUID SPEED_UUID = UUID.fromString("2c6b3b5e-2a30-4a2c-8b7c-2d02f6c52222");
    private static final UUID KB_UUID = UUID.fromString("7f3d9d2a-0b2a-49f8-9f5b-8a6e9b733333");
    private static final UUID DODGE_UUID = UUID.fromString("9b1e4d6c-6e9f-46b5-9f2a-1f3b9c444444");
    private static final UUID UNARMED_UUID = UUID.fromString("0b1a0a5e-1e3f-4f4a-9b52-21a7b9b8f555");
    private static final UUID UNARMED_AS_UUID = UUID.fromString("0b1a0a6e-1e5f-4f6a-9b52-21a7b9b8f666");

    public ChampionshipBeltItem(Item.Properties props) {
        super(props.m_41487_(1));
    }

    @Override
    protected String targetSlotId(ItemStack s) {
        return "belt";
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        if (!Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.uniqueaccessories.hold_shift").m_130940_(ChatFormatting.DARK_GRAY));
            return;
        }
        double unarmedAD = UAClientConfigCache.championshipBeltUnarmedAttackDamage;
        double unarmedAS = UAClientConfigCache.championshipBeltUnarmedAttackSpeed;
        double perArmor = UAClientConfigCache.championshipBeltArmor;
        double perSpeed = UAClientConfigCache.championshipBeltMovementSpeed;
        double perDodge = UAClientConfigCache.championshipBeltDodgeChance;
        double perKbRes = UAClientConfigCache.championshipBeltKnockbackResistance;
        tooltip.add((Component)Component.m_237110_((String)"tooltip.uniqueaccessories.championship_belt.desc1", (Object[])new Object[]{UAText.n0(unarmedAD), UAText.n1(unarmedAS)}).m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237110_((String)"tooltip.uniqueaccessories.championship_belt.desc2", (Object[])new Object[]{UAText.n0(perArmor), UAText.pct0(perSpeed), UAText.pct0(perDodge), UAText.pct0(perKbRes)}).m_130940_(ChatFormatting.GRAY));
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext ctx, UUID uuid, ItemStack stack) {
        return ImmutableMultimap.of();
    }

    public void curioTick(SlotContext ctx, ItemStack stack) {
        if (!"belt".equals(ctx.identifier())) {
            return;
        }
        LivingEntity e = ctx.entity();
        if (e.m_9236_().f_46443_) {
            return;
        }
        double perArmor = (Double)UAConfig.COMMON.championshipBeltArmor.get();
        double perSpeed = (Double)UAConfig.COMMON.championshipBeltMovementSpeed.get();
        double perDodge = (Double)UAConfig.COMMON.championshipBeltDodgeChance.get();
        double perKbRes = (Double)UAConfig.COMMON.championshipBeltKnockbackResistance.get();
        double unarmedAD = (Double)UAConfig.COMMON.championshipBeltUnarmedAttackDamage.get();
        double unarmedAS = (Double)UAConfig.COMMON.championshipBeltUnarmedAttackSpeed.get();
        int empty = 0;
        if (e.m_6844_(EquipmentSlot.HEAD).m_41619_()) {
            ++empty;
        }
        if (e.m_6844_(EquipmentSlot.CHEST).m_41619_()) {
            ++empty;
        }
        if (e.m_6844_(EquipmentSlot.LEGS).m_41619_()) {
            ++empty;
        }
        if (e.m_6844_(EquipmentSlot.FEET).m_41619_()) {
            ++empty;
        }
        boolean unarmed = e.m_21205_().m_41619_();
        double armorAdd = perArmor * (double)empty;
        double speedMul = perSpeed * (double)empty;
        double kbAdd = perKbRes * (double)empty;
        double dodgeAdd = perDodge * (double)empty;
        ChampionshipBeltItem.setOrClear(e, Attributes.f_22284_, ARMOR_UUID, armorAdd, AttributeModifier.Operation.ADDITION, "ua.champ_belt.armor_per_empty");
        ChampionshipBeltItem.setOrClear(e, Attributes.f_22279_, SPEED_UUID, speedMul, AttributeModifier.Operation.MULTIPLY_BASE, "ua.champ_belt.ms_per_empty");
        ChampionshipBeltItem.setOrClear(e, Attributes.f_22278_, KB_UUID, kbAdd, AttributeModifier.Operation.ADDITION, "ua.champ_belt.kb_per_empty");
        Attribute dodgeAttr = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("attributeslib", "dodge_chance"));
        if (dodgeAttr != null) {
            ChampionshipBeltItem.setOrClear(e, dodgeAttr, DODGE_UUID, dodgeAdd, AttributeModifier.Operation.ADDITION, "ua.champ_belt.dodge_per_empty");
        }
        ChampionshipBeltItem.setOrClear(e, Attributes.f_22281_, UNARMED_UUID, unarmed ? unarmedAD : 0.0, AttributeModifier.Operation.ADDITION, "ua.champ_belt.unarmed_ad");
        ChampionshipBeltItem.setOrClear(e, Attributes.f_22283_, UNARMED_AS_UUID, unarmed ? unarmedAS : 0.0, AttributeModifier.Operation.ADDITION, "ua.champ_belt.unarmed_as");
    }

    public void onUnequip(SlotContext ctx, ItemStack newStack, ItemStack stack) {
        LivingEntity e = ctx.entity();
        ChampionshipBeltItem.clear(e, Attributes.f_22284_, ARMOR_UUID);
        ChampionshipBeltItem.clear(e, Attributes.f_22279_, SPEED_UUID);
        ChampionshipBeltItem.clear(e, Attributes.f_22278_, KB_UUID);
        ChampionshipBeltItem.clear(e, Attributes.f_22281_, UNARMED_UUID);
        ChampionshipBeltItem.clear(e, Attributes.f_22283_, UNARMED_AS_UUID);
        Attribute dodge = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation("attributeslib", "dodge_chance"));
        if (dodge != null) {
            ChampionshipBeltItem.clear(e, dodge, DODGE_UUID);
        }
    }

    private static void setOrClear(LivingEntity e, Attribute attr, UUID id, double val, AttributeModifier.Operation op, String name) {
        AttributeInstance inst = e.m_21051_(attr);
        if (inst == null) {
            return;
        }
        if (inst.m_22111_(id) != null) {
            inst.m_22120_(id);
        }
        if (val == 0.0) {
            return;
        }
        inst.m_22118_(new AttributeModifier(id, name, val, op));
    }

    private static void clear(LivingEntity e, Attribute attr, UUID id) {
        AttributeInstance inst = e.m_21051_(attr);
        if (inst != null && inst.m_22111_(id) != null) {
            inst.m_22120_(id);
        }
    }
}

