/*
 * Decompiled with CFR 0.152.
 */
package net.genzyuro.uniqueaccessories.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.genzyuro.uniqueaccessories.item.UAUniqueCurioItem;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import top.theillusivec4.curios.api.SlotContext;

public class SupremeMeatItem
extends UAUniqueCurioItem {
    private static final UUID UUID_AD = UUID.fromString("0c9b1f8b-3a5a-4a4e-b1c5-0d1b10a00011");
    private static final UUID UUID_SPEED = UUID.fromString("0c9b1f8b-3a5a-4a4e-b1c5-0d1b10a00012");
    private static final UUID UUID_ARMOR = UUID.fromString("0c9b1f8b-3a5a-4a4e-b1c5-0d1b10a00013");
    private static final double RADIUS = 32.0;
    private static final int TICK_INTERVAL = 10;
    private static final int BUFF_TTL = 15;
    public static final String TAG_SM_EXPIRE = "ua_supreme_meat_expire";
    public static final String TAG_SM_OWNER = "ua_supreme_meat_owner";

    public SupremeMeatItem(Item.Properties props) {
        super(props.m_41487_(1));
    }

    @Override
    protected String targetSlotId(ItemStack s) {
        return "charm";
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.uniqueaccessories.supreme_meat.desc1").m_130940_(ChatFormatting.GRAY));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.uniqueaccessories.hold_shift").m_130940_(ChatFormatting.DARK_GRAY));
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext ctx, UUID uuid, ItemStack stack) {
        return ImmutableMultimap.of();
    }

    public void curioTick(SlotContext ctx, ItemStack stack) {
        if (!"charm".equals(ctx.identifier())) {
            return;
        }
        LivingEntity owner = ctx.entity();
        Level level = owner.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        if (!owner.m_6084_() || owner.m_5833_()) {
            return;
        }
        if (owner.f_19797_ % 10 != 0) {
            return;
        }
        long now = level2.m_46467_();
        AABB box = owner.m_20191_().m_82400_(32.0);
        List wolves = level2.m_6443_(Wolf.class, box, w -> w.m_6084_() && w.m_21824_() && w.m_21830_(owner) && !w.m_21825_());
        for (Wolf w2 : wolves) {
            AttributeInstance ad = w2.m_21051_(Attributes.f_22281_);
            AttributeInstance sp = w2.m_21051_(Attributes.f_22279_);
            AttributeInstance ar = w2.m_21051_(Attributes.f_22284_);
            if (ad != null && ad.m_22111_(UUID_AD) == null) {
                ad.m_22118_(new AttributeModifier(UUID_AD, "ua.suprememeat.ad", 3.0, AttributeModifier.Operation.ADDITION));
            }
            if (sp != null && sp.m_22111_(UUID_SPEED) == null) {
                sp.m_22118_(new AttributeModifier(UUID_SPEED, "ua.suprememeat.speed", 0.2, AttributeModifier.Operation.MULTIPLY_BASE));
            }
            if (ar != null && ar.m_22111_(UUID_ARMOR) == null) {
                ar.m_22118_(new AttributeModifier(UUID_ARMOR, "ua.suprememeat.armor", 4.0, AttributeModifier.Operation.ADDITION));
            }
            CompoundTag pd = w2.getPersistentData();
            pd.m_128356_(TAG_SM_EXPIRE, now + 15L);
            pd.m_128362_(TAG_SM_OWNER, owner.m_20148_());
        }
    }

    public void onUnequip(SlotContext ctx, ItemStack newStack, ItemStack stack) {
        LivingEntity owner = ctx.entity();
        Level level = owner.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        AABB box = owner.m_20191_().m_82400_(48.0);
        List wolves = level2.m_6443_(Wolf.class, box, w -> w.m_6084_() && w.m_21824_() && w.m_21830_(owner));
        for (Wolf w2 : wolves) {
            SupremeMeatItem.removeBuff(w2);
        }
    }

    public static void removeBuff(Wolf w) {
        AttributeInstance ad = w.m_21051_(Attributes.f_22281_);
        AttributeInstance sp = w.m_21051_(Attributes.f_22279_);
        AttributeInstance ar = w.m_21051_(Attributes.f_22284_);
        if (ad != null && ad.m_22111_(UUID_AD) != null) {
            ad.m_22120_(UUID_AD);
        }
        if (sp != null && sp.m_22111_(UUID_SPEED) != null) {
            sp.m_22120_(UUID_SPEED);
        }
        if (ar != null && ar.m_22111_(UUID_ARMOR) != null) {
            ar.m_22120_(UUID_ARMOR);
        }
        CompoundTag pd = w.getPersistentData();
        pd.m_128473_(TAG_SM_EXPIRE);
        pd.m_128473_(TAG_SM_OWNER);
    }
}

