/*
 * Decompiled with CFR 0.152.
 */
package net.genzyuro.uniqueaccessories.item;

import java.util.List;
import javax.annotation.Nullable;
import net.genzyuro.uniqueaccessories.config.UAClientConfigCache;
import net.genzyuro.uniqueaccessories.config.UAConfig;
import net.genzyuro.uniqueaccessories.item.UAUniqueCurioItem;
import net.genzyuro.uniqueaccessories.util.UAText;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import top.theillusivec4.curios.api.SlotContext;

public class CursedDollItem
extends UAUniqueCurioItem {
    private static final int INTERVAL_TICKS = 400;
    private static final int DURATION_TICKS = 400;
    private static final MobEffect[] POOLS = new MobEffect[]{MobEffects.f_19597_, MobEffects.f_19599_, MobEffects.f_19613_, MobEffects.f_19614_, MobEffects.f_19610_, MobEffects.f_19612_, MobEffects.f_19615_, MobEffects.f_19590_, MobEffects.f_19604_, MobEffects.f_216964_};

    public CursedDollItem(Item.Properties props) {
        super(props.m_41487_(1));
    }

    @Override
    protected String targetSlotId(ItemStack s) {
        return "charm";
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        if (!Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.uniqueaccessories.hold_shift").m_130940_(ChatFormatting.DARK_GRAY));
            return;
        }
        double radius = UAClientConfigCache.cursedDollHeadEffectRadius;
        tooltip.add((Component)Component.m_237110_((String)"tooltip.uniqueaccessories.cursed_doll.desc1", (Object[])new Object[]{UAText.n0(20.0), UAText.n0(20.0), UAText.n1(radius)}).m_130940_(ChatFormatting.GRAY));
    }

    public void curioTick(SlotContext ctx, ItemStack stack) {
        long next;
        if (!"charm".equals(ctx.identifier())) {
            return;
        }
        LivingEntity owner = ctx.entity();
        Level level = owner.m_9236_();
        if (level.f_46443_ || !owner.m_6084_() || owner.m_5833_()) {
            return;
        }
        long now = level.m_46467_();
        if (now < (next = stack.m_41784_().m_128454_("ua_cursed_next"))) {
            return;
        }
        stack.m_41784_().m_128356_("ua_cursed_next", now + 400L);
        double radius = (Double)UAConfig.COMMON.cursedDollHeadEffectRadius.get();
        AABB box = owner.m_20191_().m_82400_(radius);
        List targets = level.m_6443_(LivingEntity.class, box, t -> t.m_6084_() && !t.m_20147_());
        RandomSource rand = owner.m_217043_();
        for (LivingEntity t2 : targets) {
            MobEffect eff = POOLS[rand.m_188503_(POOLS.length)];
            int amplifier = rand.m_188503_(3);
            MobEffectInstance cur = t2.m_21124_(eff);
            if (cur != null && (cur.m_19564_() > amplifier || cur.m_19557_() > 400)) continue;
            t2.m_7292_(new MobEffectInstance(eff, 400, amplifier, true, true, true));
        }
    }
}

