/*
 * Decompiled with CFR 0.152.
 */
package net.genzyuro.uniqueaccessories.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import dev.shadowsoffire.attributeslib.api.ALObjects;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.genzyuro.uniqueaccessories.item.UAUniqueCurioItem;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.SlotContext;

public class SunStoneItem
extends UAUniqueCurioItem {
    private static final UUID UUID_AD = UUID.fromString("6cc6a9c1-5d5e-4e1c-8f0a-001122334401");
    private static final UUID UUID_AS = UUID.fromString("6cc6a9c1-5d5e-4e1c-8f0a-001122334402");
    private static final UUID UUID_ARMOR = UUID.fromString("6cc6a9c1-5d5e-4e1c-8f0a-001122334403");
    private static final UUID UUID_CRIT = UUID.fromString("6cc6a9c1-5d5e-4e1c-8f0a-001122334404");
    private static final UUID UUID_ARROW_D = UUID.fromString("6cc6a9c1-5d5e-4e1c-8f0a-001122334405");
    private static final UUID UUID_MINING = UUID.fromString("6cc6a9c1-5d5e-4e1c-8f0a-001122334406");
    private static final int HEAL_INTERVAL_TICKS = 120;

    public SunStoneItem(Item.Properties props) {
        super(props.m_41487_(1));
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.uniqueaccessories.sun_stone.desc1").m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.uniqueaccessories.sun_stone.desc2").m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.uniqueaccessories.sun_stone.desc3").m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.uniqueaccessories.sun_stone.desc4").m_130940_(ChatFormatting.GRAY));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.uniqueaccessories.hold_shift").m_130940_(ChatFormatting.DARK_GRAY));
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext ctx, UUID uuid, ItemStack stack) {
        return ImmutableMultimap.of();
    }

    public void curioTick(SlotContext ctx, ItemStack stack) {
        if (!"charm".equals(ctx.identifier())) {
            return;
        }
        LivingEntity e = ctx.entity();
        if (!e.m_6084_() || e.m_5833_()) {
            return;
        }
        if (e.m_9236_().f_46443_) {
            return;
        }
        boolean isDay = e.m_9236_().m_46461_();
        SunStoneItem.applyOrRemove(e.m_21051_(Attributes.f_22281_), UUID_AD, isDay, 4.0, AttributeModifier.Operation.ADDITION);
        SunStoneItem.applyOrRemove(e.m_21051_(Attributes.f_22283_), UUID_AS, isDay, 1.0, AttributeModifier.Operation.ADDITION);
        SunStoneItem.applyOrRemove(e.m_21051_(Attributes.f_22284_), UUID_ARMOR, isDay, 4.0, AttributeModifier.Operation.ADDITION);
        SunStoneItem.applyOrRemove(e.m_21051_((Attribute)ALObjects.Attributes.CRIT_CHANCE.get()), UUID_CRIT, isDay, 0.2, AttributeModifier.Operation.ADDITION);
        SunStoneItem.applyOrRemove(e.m_21051_((Attribute)ALObjects.Attributes.ARROW_DAMAGE.get()), UUID_ARROW_D, isDay, 0.2, AttributeModifier.Operation.ADDITION);
        SunStoneItem.applyOrRemove(e.m_21051_((Attribute)ALObjects.Attributes.MINING_SPEED.get()), UUID_MINING, isDay, 0.25, AttributeModifier.Operation.ADDITION);
        if (isDay && e.f_19797_ % 120 == 0) {
            e.m_5634_(1.0f);
        }
    }

    public void onUnequip(SlotContext ctx, ItemStack newStack, ItemStack stack) {
        LivingEntity e = ctx.entity();
        SunStoneItem.removeIfPresent(e.m_21051_(Attributes.f_22281_), UUID_AD);
        SunStoneItem.removeIfPresent(e.m_21051_(Attributes.f_22283_), UUID_AS);
        SunStoneItem.removeIfPresent(e.m_21051_(Attributes.f_22284_), UUID_ARMOR);
        SunStoneItem.removeIfPresent(e.m_21051_((Attribute)ALObjects.Attributes.CRIT_CHANCE.get()), UUID_CRIT);
        SunStoneItem.removeIfPresent(e.m_21051_((Attribute)ALObjects.Attributes.ARROW_DAMAGE.get()), UUID_ARROW_D);
        SunStoneItem.removeIfPresent(e.m_21051_((Attribute)ALObjects.Attributes.MINING_SPEED.get()), UUID_MINING);
    }

    private static void applyOrRemove(AttributeInstance inst, UUID id, boolean apply, double amount, AttributeModifier.Operation op) {
        if (inst == null) {
            return;
        }
        AttributeModifier exist = inst.m_22111_(id);
        if (apply) {
            if (exist == null) {
                inst.m_22118_(new AttributeModifier(id, "ua.sun_stone", amount, op));
            }
        } else if (exist != null) {
            inst.m_22120_(id);
        }
    }

    private static void removeIfPresent(AttributeInstance inst, UUID id) {
        if (inst != null && inst.m_22111_(id) != null) {
            inst.m_22120_(id);
        }
    }
}

