/*
 * Decompiled with CFR 0.152.
 */
package net.genzyuro.uniqueaccessories.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.genzyuro.uniqueaccessories.config.UAClientConfigCache;
import net.genzyuro.uniqueaccessories.config.UAConfig;
import net.genzyuro.uniqueaccessories.item.UAUniqueCurioItem;
import net.genzyuro.uniqueaccessories.util.UAText;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.SlotContext;

public class StarvedWolfSkullItem
extends UAUniqueCurioItem {
    private static final UUID SPEED_UUID = UUID.fromString("a3e1d1b4-6f07-4b3b-9ec9-2b6bd2b10011");
    private static final UUID AD_UUID = UUID.fromString("b9df7d6a-7c0d-4f9d-8afb-9a3a2c2c0012");

    public StarvedWolfSkullItem(Item.Properties props) {
        super(props.m_41487_(1));
    }

    @Override
    protected String targetSlotId(ItemStack s) {
        return "charm";
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        if (Screen.m_96638_()) {
            String heal = UAText.n0(UAClientConfigCache.starvedWolfSkullHeal);
            String ms = UAText.pct0(UAClientConfigCache.starvedWolfSkullMovementSpeed);
            String ad = UAText.n0(UAClientConfigCache.starvedWolfSkullAttackDamage);
            tooltip.add((Component)Component.m_237110_((String)"tooltip.uniqueaccessories.starved_wolf_skull.desc1", (Object[])new Object[]{heal}).m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237110_((String)"tooltip.uniqueaccessories.starved_wolf_skull.desc2", (Object[])new Object[]{ms}).m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237110_((String)"tooltip.uniqueaccessories.starved_wolf_skull.desc3", (Object[])new Object[]{ad}).m_130940_(ChatFormatting.GRAY));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.uniqueaccessories.hold_shift").m_130940_(ChatFormatting.DARK_GRAY));
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext ctx, UUID uuid, ItemStack stack) {
        return ImmutableMultimap.of();
    }

    public void curioTick(SlotContext ctx, ItemStack stack) {
        if (!"charm".equals(ctx.identifier())) {
            return;
        }
        LivingEntity e = ctx.entity();
        if (!e.m_6084_() || e.m_5833_()) {
            return;
        }
        if (!(e instanceof Player)) {
            return;
        }
        Player p = (Player)e;
        if (!p.m_9236_().f_46443_ && p.f_19797_ % 20 == 0) {
            MobEffectInstance cur = p.m_21124_(MobEffects.f_19612_);
            int INF = -1;
            if (cur == null || cur.m_19564_() < 1 || cur.m_19557_() != INF) {
                p.m_7292_(new MobEffectInstance(MobEffects.f_19612_, INF, 1, true, false, true));
            }
        }
        if (!p.m_9236_().f_46443_) {
            AttributeInstance ad;
            int food = p.m_36324_().m_38702_();
            AttributeInstance ms = p.m_21051_(Attributes.f_22279_);
            if (ms != null) {
                AttributeModifier exist = ms.m_22111_(SPEED_UUID);
                double msBonus = (Double)UAConfig.COMMON.starvedWolfSkullMovementSpeed.get();
                if (food <= 6 && msBonus != 0.0) {
                    if (exist == null) {
                        ms.m_22118_(new AttributeModifier(SPEED_UUID, "ua.starving_wolf.speed", msBonus, AttributeModifier.Operation.MULTIPLY_BASE));
                    }
                } else if (exist != null) {
                    ms.m_22120_(SPEED_UUID);
                }
            }
            if ((ad = p.m_21051_(Attributes.f_22281_)) != null) {
                AttributeModifier exist = ad.m_22111_(AD_UUID);
                double adBonus = (Double)UAConfig.COMMON.starvedWolfSkullAttackDamage.get();
                if (food == 0 && adBonus != 0.0) {
                    if (exist == null) {
                        ad.m_22118_(new AttributeModifier(AD_UUID, "ua.starving_wolf.ad", adBonus, AttributeModifier.Operation.ADDITION));
                    }
                } else if (exist != null) {
                    ad.m_22120_(AD_UUID);
                }
            }
        }
    }

    public void onUnequip(SlotContext ctx, ItemStack newStack, ItemStack stack) {
        AttributeInstance ad;
        LivingEntity e = ctx.entity();
        AttributeInstance ms = e.m_21051_(Attributes.f_22279_);
        if (ms != null && ms.m_22111_(SPEED_UUID) != null) {
            ms.m_22120_(SPEED_UUID);
        }
        if ((ad = e.m_21051_(Attributes.f_22281_)) != null && ad.m_22111_(AD_UUID) != null) {
            ad.m_22120_(AD_UUID);
        }
        if (e instanceof Player) {
            MobEffectInstance cur;
            Player p = (Player)e;
            if (!p.m_9236_().f_46443_ && (cur = p.m_21124_(MobEffects.f_19612_)) != null && cur.m_19564_() == 1 && cur.m_19557_() == -1) {
                p.m_21195_(MobEffects.f_19612_);
            }
        }
    }
}

