/*
 * Decompiled with CFR 0.152.
 */
package net.genzyuro.uniqueaccessories.loot;

import java.util.List;
import net.genzyuro.uniqueaccessories.registry.UAItems;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="uniqueaccessories", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class UAWandererTrades {
    private static final int MAX_USES = 1;
    private static final int TRADER_XP = 1;
    private static final float PRICE_MULT = 0.05f;
    private static final int MAX_EMERALDS = 64;

    @SubscribeEvent
    public static void onWandererTrades(WandererTradesEvent e) {
        List gen = e.getGenericTrades();
        List rare = e.getRareTrades();
        gen.add(UAWandererTrades.singleCostRange(UAItems.BLACK_BELT, 20, 30));
        gen.add(UAWandererTrades.singleCostRange(UAItems.TOOL_BELT, 25, 35));
        gen.add(UAWandererTrades.singleCostRange(UAItems.DURABLE_SPRING, 30, 40));
        gen.add(UAWandererTrades.singleCostRange(UAItems.SMALL_PROPULSION_DEVICE, 35, 45));
        rare.add(UAWandererTrades.singleCostRange(UAItems.CHAMPIONSHIP_BELT, 40, 50));
        rare.add(UAWandererTrades.singleCostRange(UAItems.TABI, 45, 55));
        rare.add(UAWandererTrades.singleCostRange(UAItems.ROCKET_SHOES, 50, 60));
        rare.add(UAWandererTrades.singleCost(UAItems.ACCESSORY_BOX, 64));
    }

    private static VillagerTrades.ItemListing singleCost(ItemLike resultItem, int emeralds) {
        int price = UAWandererTrades.clampEmeralds(emeralds);
        return (trader, random) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, price), new ItemStack((ItemLike)resultItem.m_5456_()), 1, 1, 0.05f);
    }

    private static VillagerTrades.ItemListing singleCost(RegistryObject<Item> ro, int emeralds) {
        return UAWandererTrades.singleCost((ItemLike)ro.get(), emeralds);
    }

    private static VillagerTrades.ItemListing singleCostRange(ItemLike resultItem, int min, int max) {
        int lo = Math.min(min, max);
        int hi = Math.max(min, max);
        return (trader, random) -> {
            int rolled = Mth.m_216271_((RandomSource)random, (int)lo, (int)hi);
            int price = UAWandererTrades.clampEmeralds(rolled);
            return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, price), new ItemStack((ItemLike)resultItem.m_5456_()), 1, 1, 0.05f);
        };
    }

    private static VillagerTrades.ItemListing singleCostRange(RegistryObject<Item> ro, int min, int max) {
        return UAWandererTrades.singleCostRange((ItemLike)ro.get(), min, max);
    }

    private static int clampEmeralds(int n) {
        return Mth.m_14045_((int)n, (int)1, (int)64);
    }
}

