/*
 * Decompiled with CFR 0.152.
 */
package net.genzyuro.uniqueaccessories.system;

import java.util.UUID;
import net.genzyuro.uniqueaccessories.registry.UAItems;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber(modid="uniqueaccessories", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class RoyalHoneycombEvents {
    private static final UUID BEE_AD_UUID = UUID.fromString("3a2c9e44-6f8a-4155-9b5a-9b3a0f1a1001");
    private static final UUID BEE_MS_UUID = UUID.fromString("9f0b2f77-0c3e-48a2-91b7-7f3d2c2b2002");
    private static final UUID BEE_FS_UUID = UUID.fromString("5b7a1f10-9a3d-4f5c-8e44-0ab2cc3c3003");
    private static final String TAG_TARGET = "fa_target";
    private static final String TAG_ROYAL_BEE = "fa_royal_bee";
    private static final String TAG_DESPAWN_AT = "fa_despawn_at";
    private static final String TAG_BEE_NO_XP = "fa_no_xp";
    private static final String TAG_COOLDOWN = "fa_bee_cd";
    private static final String TAG_OWNER = "fa_owner";
    private static final int COOLDOWN_TICKS = 10;
    private static final int BEE_LIFETIME_TICKS = 160;

    private static void spawnDeathSmoke(ServerLevel level, Entity e) {
        level.m_8767_((ParticleOptions)ParticleTypes.f_123759_, e.m_20185_(), e.m_20186_() + (double)e.m_20206_() * 0.5, e.m_20189_(), 12, 0.2, 0.2, 0.2, 0.02);
    }

    @SubscribeEvent
    public static void onHurt(LivingHurtEvent e) {
        CompoundTag tag;
        Bee b;
        LivingEntity attacker;
        Bee bee;
        LivingEntity victim = e.getEntity();
        if (victim.m_9236_().f_46443_) {
            return;
        }
        if (victim instanceof Bee && RoyalHoneycombEvents.isRoyalBee(bee = (Bee)victim) && (attacker = RoyalHoneycombEvents.resolveAttacker(e)) != null && attacker.m_20148_().equals(RoyalHoneycombEvents.getOwnerUUID(bee))) {
            e.setCanceled(true);
            return;
        }
        LivingEntity attacker2 = RoyalHoneycombEvents.resolveAttacker(e);
        if (attacker2 == null || attacker2 == victim) {
            return;
        }
        if (attacker2 instanceof Bee && RoyalHoneycombEvents.isRoyalBee(b = (Bee)attacker2)) {
            return;
        }
        boolean hasHoneycomb = CuriosApi.getCuriosInventory((LivingEntity)victim).map(inv -> !inv.findCurios(st -> st.m_150930_((Item)UAItems.ROYAL_HONEYCOMB.get())).isEmpty()).orElse(false);
        if (!hasHoneycomb) {
            return;
        }
        long now = ((ServerLevel)victim.m_9236_()).m_46467_();
        if (now < (tag = victim.getPersistentData()).m_128454_(TAG_COOLDOWN)) {
            return;
        }
        tag.m_128356_(TAG_COOLDOWN, now + 10L);
        RoyalHoneycombEvents.spawnRoyalBeeTowards((ServerLevel)victim.m_9236_(), victim, attacker2);
    }

    @SubscribeEvent
    public static void onBeeTick(LivingEvent.LivingTickEvent e) {
        Entity ent;
        LivingEntity livingEntity = e.getEntity();
        if (!(livingEntity instanceof Bee)) {
            return;
        }
        Bee bee = (Bee)livingEntity;
        if (bee.m_9236_().f_46443_ || !RoyalHoneycombEvents.isRoyalBee(bee)) {
            return;
        }
        ServerLevel level = (ServerLevel)bee.m_9236_();
        long time = level.m_46467_();
        CompoundTag pd = bee.getPersistentData();
        if (pd.m_128454_(TAG_DESPAWN_AT) <= time) {
            RoyalHoneycombEvents.spawnDeathSmoke(level, (Entity)bee);
            bee.m_146870_();
            return;
        }
        UUID owner = RoyalHoneycombEvents.getOwnerUUID(bee);
        LivingEntity curTgt = bee.m_5448_();
        if (owner != null && curTgt != null && owner.equals(curTgt.m_20148_())) {
            bee.m_6710_(null);
            bee.m_6925_(null);
            bee.m_7870_(0);
            curTgt = null;
        }
        if ((curTgt == null || !curTgt.m_6084_()) && pd.m_128403_(TAG_TARGET) && (ent = level.m_8791_(pd.m_128342_(TAG_TARGET))) instanceof LivingEntity) {
            LivingEntity tgt = (LivingEntity)ent;
            if (owner == null || !tgt.m_20148_().equals(owner)) {
                curTgt = tgt;
                bee.m_6710_(tgt);
            }
        }
        if (curTgt != null && curTgt.m_6084_()) {
            bee.m_21561_(true);
            bee.m_6925_(curTgt.m_20148_());
            bee.m_7870_(Math.max(bee.m_6784_(), 20));
        }
    }

    @SubscribeEvent
    public static void onExperienceDrop(LivingExperienceDropEvent e) {
        Bee bee;
        LivingEntity dead = e.getEntity();
        if (dead instanceof Bee && (bee = (Bee)dead).getPersistentData().m_128471_(TAG_BEE_NO_XP)) {
            e.setDroppedExperience(0);
        }
    }

    private static boolean isRoyalBee(Bee bee) {
        return bee.getPersistentData().m_128471_(TAG_ROYAL_BEE);
    }

    private static UUID getOwnerUUID(Bee bee) {
        CompoundTag pd = bee.getPersistentData();
        return pd.m_128403_(TAG_OWNER) ? pd.m_128342_(TAG_OWNER) : null;
    }

    private static void spawnRoyalBeeTowards(ServerLevel level, LivingEntity owner, LivingEntity target) {
        AttributeInstance fs;
        AttributeInstance ms;
        Bee bee = (Bee)EntityType.f_20550_.m_20615_((Level)level);
        if (bee == null) {
            return;
        }
        double ox = owner.m_20185_() + (owner.m_217043_().m_188500_() - 0.5) * 2.0;
        double oy = owner.m_20186_() + (double)owner.m_20206_() * 0.6;
        double oz = owner.m_20189_() + (owner.m_217043_().m_188500_() - 0.5) * 2.0;
        bee.m_7678_(ox, oy, oz, owner.m_146908_(), 0.0f);
        bee.m_6710_(target);
        bee.m_21561_(true);
        bee.m_6925_(target.m_20148_());
        bee.m_7870_(160);
        long now = level.m_46467_();
        CompoundTag pd = bee.getPersistentData();
        pd.m_128379_(TAG_ROYAL_BEE, true);
        pd.m_128356_(TAG_DESPAWN_AT, now + 160L);
        pd.m_128379_(TAG_BEE_NO_XP, true);
        pd.m_128362_(TAG_OWNER, owner.m_20148_());
        pd.m_128362_(TAG_TARGET, target.m_20148_());
        AttributeInstance ad = bee.m_21051_(Attributes.f_22281_);
        if (ad != null) {
            if (ad.m_22111_(BEE_AD_UUID) != null) {
                ad.m_22120_(BEE_AD_UUID);
            }
            ad.m_22118_(new AttributeModifier(BEE_AD_UUID, "fa.royal_bee.attack_bonus", 3.0, AttributeModifier.Operation.ADDITION));
        }
        if ((ms = bee.m_21051_(Attributes.f_22279_)) != null) {
            if (ms.m_22111_(BEE_MS_UUID) != null) {
                ms.m_22120_(BEE_MS_UUID);
            }
            ms.m_22118_(new AttributeModifier(BEE_MS_UUID, "fa.royal_bee.move_speed", 0.2, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        if ((fs = bee.m_21051_(Attributes.f_22280_)) != null) {
            if (fs.m_22111_(BEE_FS_UUID) != null) {
                fs.m_22120_(BEE_FS_UUID);
            }
            fs.m_22118_(new AttributeModifier(BEE_FS_UUID, "fa.royal_bee.flying_speed", 0.2, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        level.m_7967_((Entity)bee);
    }

    private static LivingEntity resolveAttacker(LivingHurtEvent e) {
        Projectile proj;
        Entity owner;
        Entity src = e.getSource().m_7639_();
        Entity direct = e.getSource().m_7640_();
        LivingEntity attacker = null;
        if (src instanceof LivingEntity) {
            LivingEntity le;
            attacker = le = (LivingEntity)src;
        }
        if (attacker == null && direct instanceof LivingEntity) {
            LivingEntity le2;
            attacker = le2 = (LivingEntity)direct;
        }
        if (direct instanceof Projectile && (owner = (proj = (Projectile)direct).m_19749_()) instanceof LivingEntity) {
            LivingEntity le3;
            attacker = le3 = (LivingEntity)owner;
        }
        return attacker;
    }
}

