/*
 * Decompiled with CFR 0.152.
 */
package net.genzyuro.uniqueaccessories.system;

import net.genzyuro.uniqueaccessories.registry.UAItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber(modid="uniqueaccessories", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ShinyStoneEvents {
    private static final String TAG_LAST_ACTIVE = "ua_shiny_last_active";

    private static boolean hasShinyStone(Player p) {
        return CuriosApi.getCuriosInventory((LivingEntity)p).map(inv -> !inv.findCurios(st -> st.m_150930_((Item)UAItems.SHINY_STONE.get())).isEmpty()).orElse(false);
    }

    private static void markActive(Player p) {
        if (p.m_9236_().f_46443_) {
            return;
        }
        CompoundTag pd = p.getPersistentData();
        pd.m_128356_(TAG_LAST_ACTIVE, ((ServerLevel)p.m_9236_()).m_46467_());
    }

    @SubscribeEvent
    public static void onAttack(AttackEntityEvent e) {
        if (ShinyStoneEvents.hasShinyStone(e.getEntity())) {
            ShinyStoneEvents.markActive(e.getEntity());
        }
    }

    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock e) {
        if (ShinyStoneEvents.hasShinyStone(e.getEntity())) {
            ShinyStoneEvents.markActive(e.getEntity());
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock e) {
        if (ShinyStoneEvents.hasShinyStone(e.getEntity())) {
            ShinyStoneEvents.markActive(e.getEntity());
        }
    }

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem e) {
        if (ShinyStoneEvents.hasShinyStone(e.getEntity())) {
            ShinyStoneEvents.markActive(e.getEntity());
        }
    }
}

