/*
 * Decompiled with CFR 0.152.
 */
package net.genzyuro.uniqueaccessories.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.genzyuro.uniqueaccessories.item.UAUniqueCurioItem;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import top.theillusivec4.curios.api.SlotContext;

public class StrongStickySlimeBallItem
extends UAUniqueCurioItem {
    private static final UUID SLOW_UUID = UUID.fromString("0d2b3a29-3f39-4f79-8e5f-1a6b4c11b001");

    public StrongStickySlimeBallItem(Item.Properties props) {
        super(props.m_41487_(1));
    }

    @Override
    protected String targetSlotId(ItemStack s) {
        return "charm";
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.uniqueaccessories.strong_sticky_slime_ball.desc1").m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.uniqueaccessories.strong_sticky_slime_ball.desc2").m_130940_(ChatFormatting.GRAY));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.uniqueaccessories.hold_shift").m_130940_(ChatFormatting.DARK_GRAY));
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext ctx, UUID uuid, ItemStack stack) {
        if (!"charm".equals(ctx.identifier())) {
            return ImmutableMultimap.of();
        }
        return ImmutableMultimap.builder().put((Object)Attributes.f_22279_, (Object)new AttributeModifier(uuid, "ua.sticky_slow", -0.1, AttributeModifier.Operation.MULTIPLY_BASE)).build();
    }

    public void curioTick(SlotContext ctx, ItemStack stack) {
        if (!"charm".equals(ctx.identifier())) {
            return;
        }
        LivingEntity e = ctx.entity();
        if (e.m_20072_() || e.m_20077_() || e.m_21255_() || e.m_5833_() || !e.m_6084_()) {
            return;
        }
        boolean nearWall = StrongStickySlimeBallItem.isNearSolidWall(e, 0.06);
        boolean pushing = e.f_19862_;
        if (!nearWall && !pushing) {
            return;
        }
        if (e.m_6047_()) {
            Vec3 v = e.m_20184_();
            e.m_20334_(v.f_82479_, 0.0, v.f_82481_);
            e.f_19789_ = 0.0f;
            return;
        }
        Vec3 v = e.m_20184_();
        if (pushing) {
            double climbUp = 0.16;
            double newY = Math.min(Math.max(v.f_82480_, climbUp), 0.15);
            e.m_20334_(v.f_82479_, newY, v.f_82481_);
            e.f_19789_ = 0.0f;
            return;
        }
        double maxDown = -0.12;
        double newY = v.f_82480_ < maxDown ? maxDown : (v.f_82480_ > 0.0 ? v.f_82480_ * 0.85 : v.f_82480_);
        e.m_20334_(v.f_82479_, newY, v.f_82481_);
        e.f_19789_ = 0.0f;
    }

    private static boolean isNearSolidWall(LivingEntity e, double pad) {
        double[][] offsets;
        Level lvl = e.m_9236_();
        double halfW = (double)e.m_20205_() * 0.5 + pad;
        double yMid = e.m_20186_() + (double)e.m_20206_() * 0.5;
        double x = e.m_20185_();
        double z = e.m_20189_();
        for (double[] off : offsets = new double[][]{{halfW, 0.0}, {-halfW, 0.0}, {0.0, halfW}, {0.0, -halfW}}) {
            int bz;
            int by;
            int bx = Mth.m_14107_((double)(x + off[0]));
            BlockPos pos = new BlockPos(bx, by = Mth.m_14107_((double)yMid), bz = Mth.m_14107_((double)(z + off[1])));
            BlockState st = lvl.m_8055_(pos);
            if (st.m_60795_() || st.m_60812_((BlockGetter)lvl, pos).m_83281_()) continue;
            return true;
        }
        return false;
    }
}

