/*
 * Decompiled with CFR 0.152.
 */
package net.genzyuro.uniqueaccessories.network;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.genzyuro.uniqueaccessories.config.UAClientConfigCache;
import net.genzyuro.uniqueaccessories.config.UAConfig;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class ConfigSyncS2C {
    public final double goldenEggChance;
    public final double royalHoneycombChance;
    public final Map<String, Double> lootChances;
    public final int rocketShoesMaxTicks;
    public final double amplifierStoneRadius;
    public final double amplifierStoneDamage;
    public final double magickQuiverArrowDamage;
    public final double magickQuiverArrowVelocity;
    public final double goldenEggDamage;
    public final double toolBeltBlockReach;
    public final double smallPropulsionMultiplier;
    public final double sunStoneAttackDamage;
    public final double sunStoneArmor;
    public final double sunStoneArrowDamage;
    public final double sunStoneCriticalChance;
    public final double sunStoneMiningSpeed;
    public final int sunStoneAttackSpeed;
    public final int sunStoneHealSec;
    public final double moonStoneAttackDamage;
    public final double moonStoneArmor;
    public final double moonStoneArrowDamage;
    public final double moonStoneCriticalChance;
    public final double moonStoneMiningSpeed;
    public final int moonStoneAttackSpeed;
    public final int moonStoneHealSec;
    public final double heroEmblemAttackDamage;
    public final double heroEmblemArrowDamage;
    public final double heroEmblemLowHpAttackDamage;
    public final double heroEmblemLowHpArrowDamage;
    public final double heroEmblemLowHpMovementSpeed;
    public final double heroEmblem1HpAttackDamage;
    public final double heroEmblem1HpArrowDamage;
    public final double heroEmblem1HpDodgeChance;
    public final double heroEmblem1HpCriticalChance;
    public final double burningSoulLevelCost;
    public final double soulGemHeal;
    public final double devilsEyeballCriticalChance;
    public final double devilsEyeballCriticalDamage;
    public final double starvedWolfSkullHeal;
    public final double starvedWolfSkullMovementSpeed;
    public final double starvedWolfSkullAttackDamage;
    public final double witheredHeartMaxHp;
    public final double fossilSharkToothPenetration;
    public final double sharpFishingHookDamage;
    public final double ancientChiselMining;
    public final double cursedDollHeadEffectRadius;
    public final double snowGolemDollSnowballDamage;
    public final double championshipBeltUnarmedAttackDamage;
    public final double championshipBeltUnarmedAttackSpeed;
    public final double championshipBeltArmor;
    public final double championshipBeltMovementSpeed;
    public final double championshipBeltDodgeChance;
    public final double championshipBeltKnockbackResistance;
    public final double blackBeltDodgeChance;
    public final double silverCatTailSprintSpeed;
    public final double tabiWalkSpeed;
    public final double ankletOfFortuneDebuffNegateChance;
    public final double durableSpringMovementSpeed;

    public ConfigSyncS2C(double goldenEggChance, double royalHoneycombChance, Map<String, Double> lootChances, int rocketShoesMaxTicks, double amplifierStoneRadius, double amplifierStoneDamage, double magickQuiverArrowDamage, double magickQuiverArrowVelocity, double toolBeltBlockReach, double smallPropulsionMultiplier, double goldenEggDamage, double sunStoneAttackDamage, double sunStoneArmor, double sunStoneArrowDamage, double sunStoneCriticalChance, double sunStoneMiningSpeed, int sunStoneAttackSpeed, int sunStoneHealSec, double moonStoneAttackDamage, double moonStoneArmor, double moonStoneArrowDamage, double moonStoneCriticalChance, double moonStoneMiningSpeed, int moonStoneAttackSpeed, int moonStoneHealSec, double heroEmblemAttackDamage, double heroEmblemArrowDamage, double heroEmblemLowHpAttackDamage, double heroEmblemLowHpArrowDamage, double heroEmblemLowHpMovementSpeed, double heroEmblem1HpAttackDamage, double heroEmblem1HpArrowDamage, double heroEmblem1HpDodgeChance, double heroEmblem1HpCriticalChance, double burningSoulLevelCost, double soulGemHeal, double devilsEyeballCriticalChance, double devilsEyeballCriticalDamage, double starvedWolfSkullHeal, double starvedWolfSkullMovementSpeed, double starvedWolfSkullAttackDamage, double witheredHeartMaxHp, double fossilSharkToothPenetration, double sharpFishingHookDamage, double ancientChiselMining, double cursedDollHeadEffectRadius, double snowGolemDollSnowballDamage, double championshipBeltUnarmedAttackDamage, double championshipBeltUnarmedAttackSpeed, double championshipBeltArmor, double championshipBeltMovementSpeed, double championshipBeltDodgeChance, double championshipBeltKnockbackResistance, double blackBeltDodgeChance, double silverCatTailSprintSpeed, double tabiWalkSpeed, double ankletOfFortuneDebuffNegateChance, double durableSpringMovementSpeed) {
        this.goldenEggChance = goldenEggChance;
        this.royalHoneycombChance = royalHoneycombChance;
        this.lootChances = new HashMap<String, Double>(lootChances);
        this.rocketShoesMaxTicks = rocketShoesMaxTicks;
        this.amplifierStoneRadius = amplifierStoneRadius;
        this.amplifierStoneDamage = amplifierStoneDamage;
        this.magickQuiverArrowDamage = magickQuiverArrowDamage;
        this.magickQuiverArrowVelocity = magickQuiverArrowVelocity;
        this.toolBeltBlockReach = toolBeltBlockReach;
        this.smallPropulsionMultiplier = smallPropulsionMultiplier;
        this.goldenEggDamage = goldenEggDamage;
        this.sunStoneAttackDamage = sunStoneAttackDamage;
        this.sunStoneArmor = sunStoneArmor;
        this.sunStoneArrowDamage = sunStoneArrowDamage;
        this.sunStoneCriticalChance = sunStoneCriticalChance;
        this.sunStoneMiningSpeed = sunStoneMiningSpeed;
        this.sunStoneAttackSpeed = sunStoneAttackSpeed;
        this.sunStoneHealSec = sunStoneHealSec;
        this.moonStoneAttackDamage = moonStoneAttackDamage;
        this.moonStoneArmor = moonStoneArmor;
        this.moonStoneArrowDamage = moonStoneArrowDamage;
        this.moonStoneCriticalChance = moonStoneCriticalChance;
        this.moonStoneMiningSpeed = moonStoneMiningSpeed;
        this.moonStoneAttackSpeed = moonStoneAttackSpeed;
        this.moonStoneHealSec = moonStoneHealSec;
        this.heroEmblemAttackDamage = heroEmblemAttackDamage;
        this.heroEmblemArrowDamage = heroEmblemArrowDamage;
        this.heroEmblemLowHpAttackDamage = heroEmblemLowHpAttackDamage;
        this.heroEmblemLowHpArrowDamage = heroEmblemLowHpArrowDamage;
        this.heroEmblemLowHpMovementSpeed = heroEmblemLowHpMovementSpeed;
        this.heroEmblem1HpAttackDamage = heroEmblem1HpAttackDamage;
        this.heroEmblem1HpArrowDamage = heroEmblem1HpArrowDamage;
        this.heroEmblem1HpDodgeChance = heroEmblem1HpDodgeChance;
        this.heroEmblem1HpCriticalChance = heroEmblem1HpCriticalChance;
        this.burningSoulLevelCost = burningSoulLevelCost;
        this.soulGemHeal = soulGemHeal;
        this.devilsEyeballCriticalChance = devilsEyeballCriticalChance;
        this.devilsEyeballCriticalDamage = devilsEyeballCriticalDamage;
        this.starvedWolfSkullHeal = starvedWolfSkullHeal;
        this.starvedWolfSkullMovementSpeed = starvedWolfSkullMovementSpeed;
        this.starvedWolfSkullAttackDamage = starvedWolfSkullAttackDamage;
        this.witheredHeartMaxHp = witheredHeartMaxHp;
        this.fossilSharkToothPenetration = fossilSharkToothPenetration;
        this.sharpFishingHookDamage = sharpFishingHookDamage;
        this.ancientChiselMining = ancientChiselMining;
        this.cursedDollHeadEffectRadius = cursedDollHeadEffectRadius;
        this.snowGolemDollSnowballDamage = snowGolemDollSnowballDamage;
        this.championshipBeltUnarmedAttackDamage = championshipBeltUnarmedAttackDamage;
        this.championshipBeltUnarmedAttackSpeed = championshipBeltUnarmedAttackSpeed;
        this.championshipBeltArmor = championshipBeltArmor;
        this.championshipBeltMovementSpeed = championshipBeltMovementSpeed;
        this.championshipBeltDodgeChance = championshipBeltDodgeChance;
        this.championshipBeltKnockbackResistance = championshipBeltKnockbackResistance;
        this.blackBeltDodgeChance = blackBeltDodgeChance;
        this.silverCatTailSprintSpeed = silverCatTailSprintSpeed;
        this.tabiWalkSpeed = tabiWalkSpeed;
        this.ankletOfFortuneDebuffNegateChance = ankletOfFortuneDebuffNegateChance;
        this.durableSpringMovementSpeed = durableSpringMovementSpeed;
    }

    public static ConfigSyncS2C fromServerSpec(UAConfig.Common s) {
        HashMap<String, Double> dynLoot = new HashMap<String, Double>();
        if (s.lootChances != null) {
            s.lootChances.forEach((k, v) -> dynLoot.put((String)k, (Double)v.get()));
        }
        return new ConfigSyncS2C((Double)s.goldenEggChance.get(), (Double)s.royalHoneycombChance.get(), dynLoot, (Integer)s.rocketShoesMaxTicks.get(), (Double)s.amplifierStoneRadius.get(), (Double)s.amplifierStoneDamage.get(), (Double)s.magickQuiverArrowDamage.get(), (Double)s.magickQuiverArrowVelocity.get(), (Double)s.toolBeltBlockReach.get(), (Double)s.smallPropulsionMultiplier.get(), (Double)s.goldenEggDamage.get(), (Double)s.sunStoneAttackDamage.get(), (Double)s.sunStoneArmor.get(), (Double)s.sunStoneArrowDamage.get(), (Double)s.sunStoneCriticalChance.get(), (Double)s.sunStoneMiningSpeed.get(), (Integer)s.sunStoneAttackSpeed.get(), (Integer)s.sunStoneHealSec.get(), (Double)s.moonStoneAttackDamage.get(), (Double)s.moonStoneArmor.get(), (Double)s.moonStoneArrowDamage.get(), (Double)s.moonStoneCriticalChance.get(), (Double)s.moonStoneMiningSpeed.get(), (Integer)s.moonStoneAttackSpeed.get(), (Integer)s.moonStoneHealSec.get(), (Double)s.heroEmblemAttackDamage.get(), (Double)s.heroEmblemArrowDamage.get(), (Double)s.heroEmblemLowHpAttackDamage.get(), (Double)s.heroEmblemLowHpArrowDamage.get(), (Double)s.heroEmblemLowHpMovementSpeed.get(), (Double)s.heroEmblem1HpAttackDamage.get(), (Double)s.heroEmblem1HpArrowDamage.get(), (Double)s.heroEmblem1HpDodgeChance.get(), (Double)s.heroEmblem1HpCriticalChance.get(), (Double)s.burningSoulLevelCost.get(), (Double)s.soulGemHeal.get(), (Double)s.devilsEyeballCriticalChance.get(), (Double)s.devilsEyeballCriticalDamage.get(), (Double)s.starvedWolfSkullHeal.get(), (Double)s.starvedWolfSkullMovementSpeed.get(), (Double)s.starvedWolfSkullAttackDamage.get(), (Double)s.witheredHeartMaxHp.get(), (Double)s.fossilSharkToothPenetration.get(), (Double)s.sharpFishingHookDamage.get(), (Double)s.ancientChiselMining.get(), (Double)s.cursedDollHeadEffectRadius.get(), (Double)s.snowGolemDollSnowballDamage.get(), (Double)s.championshipBeltUnarmedAttackDamage.get(), (Double)s.championshipBeltUnarmedAttackSpeed.get(), (Double)s.championshipBeltArmor.get(), (Double)s.championshipBeltMovementSpeed.get(), (Double)s.championshipBeltDodgeChance.get(), (Double)s.championshipBeltKnockbackResistance.get(), (Double)s.blackBeltDodgeChance.get(), (Double)s.silverCatTailSprintSpeed.get(), (Double)s.tabiWalkSpeed.get(), (Double)s.ankletOfFortuneDebuffNegateChance.get(), (Double)s.durableSpringMovementSpeed.get());
    }

    public static void encode(ConfigSyncS2C m, FriendlyByteBuf buf) {
        buf.writeDouble(m.goldenEggChance);
        buf.writeDouble(m.royalHoneycombChance);
        buf.m_130130_(m.lootChances.size());
        for (Map.Entry<String, Double> e : m.lootChances.entrySet()) {
            buf.m_130070_(e.getKey());
            buf.writeDouble(e.getValue().doubleValue());
        }
        buf.m_130130_(m.rocketShoesMaxTicks);
        buf.writeDouble(m.amplifierStoneRadius);
        buf.writeDouble(m.amplifierStoneDamage);
        buf.writeDouble(m.magickQuiverArrowDamage);
        buf.writeDouble(m.magickQuiverArrowVelocity);
        buf.writeDouble(m.toolBeltBlockReach);
        buf.writeDouble(m.smallPropulsionMultiplier);
        buf.writeDouble(m.goldenEggDamage);
        buf.writeDouble(m.sunStoneAttackDamage);
        buf.writeDouble(m.sunStoneArmor);
        buf.writeDouble(m.sunStoneArrowDamage);
        buf.writeDouble(m.sunStoneCriticalChance);
        buf.writeDouble(m.sunStoneMiningSpeed);
        buf.m_130130_(m.sunStoneAttackSpeed);
        buf.m_130130_(m.sunStoneHealSec);
        buf.writeDouble(m.moonStoneAttackDamage);
        buf.writeDouble(m.moonStoneArmor);
        buf.writeDouble(m.moonStoneArrowDamage);
        buf.writeDouble(m.moonStoneCriticalChance);
        buf.writeDouble(m.moonStoneMiningSpeed);
        buf.m_130130_(m.moonStoneAttackSpeed);
        buf.m_130130_(m.moonStoneHealSec);
        buf.writeDouble(m.heroEmblemAttackDamage);
        buf.writeDouble(m.heroEmblemArrowDamage);
        buf.writeDouble(m.heroEmblemLowHpAttackDamage);
        buf.writeDouble(m.heroEmblemLowHpArrowDamage);
        buf.writeDouble(m.heroEmblemLowHpMovementSpeed);
        buf.writeDouble(m.heroEmblem1HpAttackDamage);
        buf.writeDouble(m.heroEmblem1HpArrowDamage);
        buf.writeDouble(m.heroEmblem1HpDodgeChance);
        buf.writeDouble(m.heroEmblem1HpCriticalChance);
        buf.writeDouble(m.burningSoulLevelCost);
        buf.writeDouble(m.soulGemHeal);
        buf.writeDouble(m.devilsEyeballCriticalChance);
        buf.writeDouble(m.devilsEyeballCriticalDamage);
        buf.writeDouble(m.starvedWolfSkullHeal);
        buf.writeDouble(m.starvedWolfSkullMovementSpeed);
        buf.writeDouble(m.starvedWolfSkullAttackDamage);
        buf.writeDouble(m.witheredHeartMaxHp);
        buf.writeDouble(m.fossilSharkToothPenetration);
        buf.writeDouble(m.sharpFishingHookDamage);
        buf.writeDouble(m.ancientChiselMining);
        buf.writeDouble(m.cursedDollHeadEffectRadius);
        buf.writeDouble(m.snowGolemDollSnowballDamage);
        buf.writeDouble(m.championshipBeltUnarmedAttackDamage);
        buf.writeDouble(m.championshipBeltUnarmedAttackSpeed);
        buf.writeDouble(m.championshipBeltArmor);
        buf.writeDouble(m.championshipBeltMovementSpeed);
        buf.writeDouble(m.championshipBeltDodgeChance);
        buf.writeDouble(m.championshipBeltKnockbackResistance);
        buf.writeDouble(m.blackBeltDodgeChance);
        buf.writeDouble(m.silverCatTailSprintSpeed);
        buf.writeDouble(m.tabiWalkSpeed);
        buf.writeDouble(m.ankletOfFortuneDebuffNegateChance);
        buf.writeDouble(m.durableSpringMovementSpeed);
    }

    public static ConfigSyncS2C decode(FriendlyByteBuf buf) {
        double goldenEggChance = buf.readDouble();
        double royalHoneycombChance = buf.readDouble();
        int lootSize = buf.m_130242_();
        HashMap<String, Double> dynLoot = new HashMap<String, Double>(Math.max(lootSize, 0));
        for (int i = 0; i < lootSize; ++i) {
            String key = buf.m_130277_();
            double val = buf.readDouble();
            dynLoot.put(key, val);
        }
        int rocketShoesMaxTicks = buf.m_130242_();
        double amplifierStoneRadius = buf.readDouble();
        double amplifierStoneDamage = buf.readDouble();
        double magickQuiverArrowDamage = buf.readDouble();
        double magickQuiverArrowVelocity = buf.readDouble();
        double toolBeltBlockReach = buf.readDouble();
        double smallPropulsionMultiplier = buf.readDouble();
        double goldenEggDamage = buf.readDouble();
        double sunStoneAttackDamage = buf.readDouble();
        double sunStoneArmor = buf.readDouble();
        double sunStoneArrowDamage = buf.readDouble();
        double sunStoneCriticalChance = buf.readDouble();
        double sunStoneMiningSpeed = buf.readDouble();
        int sunStoneAttackSpeed = buf.m_130242_();
        int sunStoneHealSec = buf.m_130242_();
        double moonStoneAttackDamage = buf.readDouble();
        double moonStoneArmor = buf.readDouble();
        double moonStoneArrowDamage = buf.readDouble();
        double moonStoneCriticalChance = buf.readDouble();
        double moonStoneMiningSpeed = buf.readDouble();
        int moonStoneAttackSpeed = buf.m_130242_();
        int moonStoneHealSec = buf.m_130242_();
        double heroEmblemAttackDamage = buf.readDouble();
        double heroEmblemArrowDamage = buf.readDouble();
        double heroEmblemLowHpAttackDamage = buf.readDouble();
        double heroEmblemLowHpArrowDamage = buf.readDouble();
        double heroEmblemLowHpMovementSpeed = buf.readDouble();
        double heroEmblem1HpAttackDamage = buf.readDouble();
        double heroEmblem1HpArrowDamage = buf.readDouble();
        double heroEmblem1HpDodgeChance = buf.readDouble();
        double heroEmblem1HpCriticalChance = buf.readDouble();
        double burningSoulLevelCost = buf.readDouble();
        double soulGemHeal = buf.readDouble();
        double devilsEyeballCriticalChance = buf.readDouble();
        double devilsEyeballCriticalDamage = buf.readDouble();
        double starvedWolfSkullHeal = buf.readDouble();
        double starvedWolfSkullMovementSpeed = buf.readDouble();
        double starvedWolfSkullAttackDamage = buf.readDouble();
        double witheredHeartMaxHp = buf.readDouble();
        double fossilSharkToothPenetration = buf.readDouble();
        double sharpFishingHookDamage = buf.readDouble();
        double ancientChiselMining = buf.readDouble();
        double cursedDollHeadEffectRadius = buf.readDouble();
        double snowGolemDollSnowballDamage = buf.readDouble();
        double championshipBeltUnarmedAttackDamage = buf.readDouble();
        double championshipBeltUnarmedAttackSpeed = buf.readDouble();
        double championshipBeltArmor = buf.readDouble();
        double championshipBeltMovementSpeed = buf.readDouble();
        double championshipBeltDodgeChance = buf.readDouble();
        double championshipBeltKnockbackResistance = buf.readDouble();
        double blackBeltDodgeChance = buf.readDouble();
        double silverCatTailSprintSpeed = buf.readDouble();
        double tabiWalkSpeed = buf.readDouble();
        double ankletOfFortuneDebuffNegateChance = buf.readDouble();
        double durableSpringMovementSpeed = buf.readDouble();
        return new ConfigSyncS2C(goldenEggChance, royalHoneycombChance, dynLoot, rocketShoesMaxTicks, amplifierStoneRadius, amplifierStoneDamage, magickQuiverArrowDamage, magickQuiverArrowVelocity, toolBeltBlockReach, smallPropulsionMultiplier, goldenEggDamage, sunStoneAttackDamage, sunStoneArmor, sunStoneArrowDamage, sunStoneCriticalChance, sunStoneMiningSpeed, sunStoneAttackSpeed, sunStoneHealSec, moonStoneAttackDamage, moonStoneArmor, moonStoneArrowDamage, moonStoneCriticalChance, moonStoneMiningSpeed, moonStoneAttackSpeed, moonStoneHealSec, heroEmblemAttackDamage, heroEmblemArrowDamage, heroEmblemLowHpAttackDamage, heroEmblemLowHpArrowDamage, heroEmblemLowHpMovementSpeed, heroEmblem1HpAttackDamage, heroEmblem1HpArrowDamage, heroEmblem1HpDodgeChance, heroEmblem1HpCriticalChance, burningSoulLevelCost, soulGemHeal, devilsEyeballCriticalChance, devilsEyeballCriticalDamage, starvedWolfSkullHeal, starvedWolfSkullMovementSpeed, starvedWolfSkullAttackDamage, witheredHeartMaxHp, fossilSharkToothPenetration, sharpFishingHookDamage, ancientChiselMining, cursedDollHeadEffectRadius, snowGolemDollSnowballDamage, championshipBeltUnarmedAttackDamage, championshipBeltUnarmedAttackSpeed, championshipBeltArmor, championshipBeltMovementSpeed, championshipBeltDodgeChance, championshipBeltKnockbackResistance, blackBeltDodgeChance, silverCatTailSprintSpeed, tabiWalkSpeed, ankletOfFortuneDebuffNegateChance, durableSpringMovementSpeed);
    }

    public static void handle(ConfigSyncS2C msg, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context c = ctx.get();
        if (c.getDirection().getReceptionSide() != LogicalSide.CLIENT) {
            c.setPacketHandled(true);
            return;
        }
        c.enqueueWork(() -> UAClientConfigCache.apply(msg));
        c.setPacketHandled(true);
    }
}

