/*
 * Decompiled with CFR 0.152.
 */
package com.pla.dailyboss_irons_spellbooks.mixins;

import com.pla.pladailyboss.entity.KeyEntity;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.entity.mobs.wizards.fire_boss.FireBossEntity;
import io.redspace.ironsspellbooks.item.CinderousSoulcallerItem;
import io.redspace.ironsspellbooks.registries.EntityRegistry;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import java.util.Objects;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={KeyEntity.class}, remap=false)
public class KeyEntityMixin {
    private static final Logger LOGGER = LogManager.getLogger();

    public Mob spawnIronBoss(LivingEntity entity, Player player) {
        Vec3 center = entity.getBoundingBox().getCenter().add(0.0, 0.6, 0.0);
        float yRot = Utils.getAngle((double)center.x, (double)center.z, (double)player.getX(), (double)player.getZ()) * 57.295776f;
        FireBossEntity fireBoss = (FireBossEntity)((EntityType)EntityRegistry.FIRE_BOSS.get()).create(entity.level());
        fireBoss.moveTo(center);
        fireBoss.setYRot(yRot + 90.0f);
        fireBoss.triggerSpawnAnim();
        fireBoss.finalizeSpawn((ServerLevelAccessor)entity.level(), entity.level().getCurrentDifficultyAt(player.blockPosition()), MobSpawnType.MOB_SUMMONED, null);
        entity.level().addFreshEntity((Entity)fireBoss);
        CinderousSoulcallerItem item = (CinderousSoulcallerItem)ItemRegistry.CINDEROUS_SOULCALLER.get();
        item.tollEffects((ServerLevel)entity.level(), center, true);
        return fireBoss;
    }

    @Inject(method={"processMob"}, at={@At(value="TAIL")})
    private void addCompat(String spawnedMobId, Mob mob, ServerPlayer player, CallbackInfo ci) {
        if (Objects.equals(spawnedMobId, "irons_spellbooks:dead_king_corpse")) {
            mob.interact((Player)player, InteractionHand.OFF_HAND);
        }
    }

    @Inject(method={"customizeSpawnMob"}, at={@At(value="HEAD")}, cancellable=true)
    private void addCustomSpawnLogic(String spawnedMobId, Player player, CallbackInfoReturnable<Mob> cir) {
        if (Objects.equals(spawnedMobId, "irons_spellbooks:fire_boss")) {
            KeyEntity self = (KeyEntity)this;
            Mob boss = this.spawnIronBoss((LivingEntity)self, player);
            cir.setReturnValue((Object)boss);
            cir.cancel();
        }
    }
}

